<?php $__env->startSection('content'); ?>

<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Sub Genre</h6>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['create-subgenre'])): ?>
            <div class="view-all-release-search">
                <a href="<?php echo e(route('subgenre.create')); ?>"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            <?php endif; ?>
           
        </div>


        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Genre</th>
                        <th>Sub Genre Name</th>
                        <th>Sub Genre Description</th>
                        <th>Sub Genre Status</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subgenreObj): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(++$i); ?></td>

                        <td>
                            <?php
                            $genreName = getGenreById($subgenreObj->genre_id);
                            echo $genreName->title;
                            ?>
                        </td>

                        <td><?php echo e($subgenreObj->title); ?></td>
                        <td><?php echo e($subgenreObj->description); ?></td>
                        <td>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-subgenre'])): ?>
                            <input type="checkbox" id="genre_<?php echo e($subgenreObj->id); ?>" class="form-check-input genreStatus" name="genreStatus" <?php if($subgenreObj->status==1): ?> checked <?php endif; ?> />
                         <?php endif; ?>


                            <?php if(!empty($subgenreObj->status)): ?>
                            <label id="genreStatus_<?php echo e($subgenreObj->id); ?>" class="badge bg-success">Active</label>
                            <?php else: ?>
                            <label id="genreStatus_<?php echo e($subgenreObj->id); ?>" class="badge bg-danger">Disabled</label>
                            <?php endif; ?>
                        </td>
                        <td>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-subgenre'])): ?>
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('subgenre.edit',$subgenreObj->id)); ?>"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['delete-subgenre'])): ?>
                            <form method="POST" action="<?php echo e(route('subgenre.destroy', $subgenreObj->id)); ?>" style="display:inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                        <?php endif; ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo $data->links('pagination::bootstrap-5'); ?>

        </div>
    </div>
</section>


<script>
    $(document).ready(function() {
        $(".genreStatus").change(function() {
            var genreStr = $(this).attr('id');
            var genreArr = genreStr.split("_");
            var genreId = genreArr[1];


            $.ajax({
                url: "<?php echo e(route('subgenre.status.update')); ?>",
                type: "POST",
                data: {
                    genreId: genreId,
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(requestResponse) {

                    var genreStatusId = "genreStatus_" + genreId;

                    if (requestResponse == "disabledGenre") {
                        $(this).prop('checked', false);
                        $("#" + genreStatusId).removeClass("bg-success");
                        $("#" + genreStatusId).addClass("bg-danger");
                        $("#" + genreStatusId).text("Disabled");
                    } else if (requestResponse == "activeGenre") {
                        $(this).prop('checked', true);
                        $("#" + genreStatusId).addClass("bg-success");
                        $("#" + genreStatusId).removeClass("bg-danger");
                        $("#" + genreStatusId).text("Active");
                    }

                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/subgenres/index.blade.php ENDPATH**/ ?>