
<?php $__env->startSection('content'); ?>

<?php if(empty(Session::get('release_form_show'))): ?>
<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Release</h6>
        </div>
    </div>

    <?php if(count($errors) > 0): ?>
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <form class="add-releses-form" method="POST" action="<?php echo e(route('release.labels.save')); ?>" id="frmReleaseStep1212" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="releases-sec-main">
            <div class="row">
                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Label<i class="fa-solid fa-circle-info"></i></label>
                        <select name="label_id" id="admin_label_id" class="form-control">
                            <option value="">Select Label</option>
                            <?php $__currentLoopData = $lablesUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>" <?php if($release->label_id == $user->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($user->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <?php
                if(!empty($release->label_id)){
                $label_id = $release->label_id;
                $sublabels = getSublabelByLabelId($label_id);
                }
                ?>


                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="releaseSubLabelsOfLabels">
                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Sub Label
                            <i class="fa-solid fa-circle-info">
                            </i></label>
                        <select name="sublabel_id" id="sublabel_id" class="form-control">
                            <option value="">Select Sub Label</option>
                            <?php if(!empty($sublabels)): ?>
                            <?php $__currentLoopData = $sublabels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sublabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sublabel->id); ?>" <?php if($release->sublabel_id == $sublabel->id): ?> selected <?php endif; ?>><?php echo e($sublabel->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="form-group-button frm_genre_nextform">
                    <button type="submit" class="btn lyricsBtn" id="lyricsSubmit">Next Step</button>
                </div>

            </div>
        </div>
    </form>
</section>

<script>
    $("#admin_label_id").change(function() {
        var label_id = $(this).val();
        // alert(label_id);return false;
        $.ajax({
            url: "<?php echo e(route('release.getsublabels.oflables')); ?>",
            type: "POST",
            data: {
                'label_id': label_id,
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            cache: false,
            success: function(html) {
                if (html) {
                    $("#releaseSubLabelsOfLabels").html(html);
                }
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });
</script>
<?php endif; ?>

<?php
$selectedLabels = null;
if(Session::get('release_labels')){
$selectedLabelArr = Session::get('release_labels');

if(!empty($selectedLabelArr['lable']))
{
$selectedLabelId = $selectedLabelArr['lable'];
$user = getUserById($selectedLabelId);
$selectedLabels = $user->name ?? '';
}

if(!empty($selectedLabelArr['sublabel'])){
$selectedLabelId = $selectedLabelArr['sublabel'];
$user = getUserById($selectedLabelId);
$selectedLabels = $user->name ?? '';
}
}
?>



<section class="right-sidebar" id="sidebarRight" <?php if(empty(Session::get('release_form_show'))): ?> style="display:none;" <?php endif; ?>>

    <?php if(count($errors) > 0): ?>
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ul>
    </div>
    <?php endif; ?>

    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Release</h6>
        </div>
        <div class="mt-4">
            <a href="<?php echo e(route('release.labels.delete')); ?>" style="float: right;color: #35bdaa;">
                <i class="fa fa-arrow-left" aria-hidden="true"></i>
            </a>
            <div class="tab-heading">
                <h6>Release Type</h6>
            </div>

            <ul class="nav nav-tabs rel-type-main" id="myTab" role="tablist">
                <li class="nav-item radio-btn rel-type-box" role="presentation">
                    <input type="radio" name="release_form_type" class="form-check-input" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="true" checked>

                    <label class="form-check-label" for="">Album</label>
                </li>
            </ul>


            <?php if(!empty($release->artwork)): ?>
                <style>
                    .albumartworkpreviewimage{
                        background-image: url("<?php echo e(Storage::url($release->artwork)); ?>")
                    }
                    </style>
            <?php endif; ?>


            <?php if(!empty($release->apple_art)): ?>
                <style>
                    .albumappleartworkpreviewimage{
                        background-image: url("<?php echo e(Storage::url($release->apple_art)); ?>")
                    }
                    </style>
            <?php endif; ?>

            <!-- Tab Content -->
            <div class="tab-content mt-3">
                <!-- for album  -->
                <div class="tab-pane fade s how active show" id="profile">

                    <form class="add-releses-form" method="POST" action="<?php echo e(route('release.album.update', $release->id)); ?>" id="frmReleaseStepAlbum1" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                        <input type="hidden" class="form-control" name="release_type" value="album">

                        <div class="chose-file-sec">
                            <div class="chose-mainbox albumartworkpreviewimage" id="release_album_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>

                                <?php if(empty($release->artwork)): ?>
                                <div class="chose-file-content" id="album_chose-file-content_artwork">
                                    <h5 class="required">Choose file for Art Work</h5>
                                </div>
                                <?php endif; ?>

                                <input type="file" name="artwork" id="album_artwork_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
                                <p id="album_error-message" style="color:#dc3545"></p>
                            </div>

                            <div class="chose-mainbox albumappleartworkpreviewimage" id="release_album_apple_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>

                                <?php if(empty($release->apple_art)): ?>
                                <div class="chose-file-content" id="album_apple_chose-file-content_artwork">
                                    <h5>Choose file for Apple (Motion Art)</h5>
                                </div>
                                <?php endif; ?>

                                <input type="file" name="apple_art" id="album_apple_art_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
                            </div>


                            <div class="chose-mainbox" data-bs-toggle="modal" data-bs-target="#addAlbumLyrics">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content">
                                    <h5>Add Lyrics</h5>
                                </div>

                            </div>

                            <div class="modal fade add-lyricist-modal" id="addAlbumLyrics" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Add Lyricist</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                                        </div>

                                        <div class="modal-body">
                                            <div class="Upload-mainbox" id="releaseuploadlyrics">
                                                <div class="file-icon">
                                                    <i class="fa-solid fa-plus"></i>
                                                </div>
                                                <h5>Upload Lyrics</h5>
                                            </div>
                                            <p>Or</p>

                                            <input type="file" name="singleReleaseLyricFile" id="albumReleaseLyricFile" class="form-control" style="display:none;" accept=".txt" />
                                            <div class="form-group">
                                                <label class="form-label" for="uploadLyrics">Paste</label>
                                                <input class="form-control" type="text" id="lyric_urls" name="lyric_urls" value="<?php echo e($release->lyric_urls ?? ''); ?>" />
                                            </div>
                                            <div class="form-group-button">
                                                <button type="button" class="btn lyricsBtn" id="albumReleaselyricsSubmit">Upload</button>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="releases-sec-main">
                            <!-- <form class="add-releses-form"> -->
                            <div class="row">
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="language">Language<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="lang" id="language" class="form-control" required>
                                            <option value="">Select Language</option>
                                            <?php $__currentLoopData = getLangs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langCode => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($langCode); ?>" <?php if($release->lang == $langCode ): ?> selected <?php endif; ?>><?php echo e(ucfirst($langName)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="Release-Title">Release Title<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="title" id="Release-Title" required value="<?php echo e($release->title ?? ''); ?>">
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="primary-artist">Choose Primary Artist<i class="fa-solid fa-circle-info"></i></label>

                                        <div class="artist-sec">
                                            <select name="artists" id="artists" class="form-control" required>
                                                <option value="">Select Artist</option>
                                                <?php $__currentLoopData = $artists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $artist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($artist->id); ?>" 
                                                <?php if( $release->artists==$artist->id): ?> selected <?php endif; ?>>
                                                <?php echo e(ucfirst($artist->name)); ?>

                                                </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['create-artists'])): ?>
                                            <a href="javascript:void(0);" id="addAlbumArtistRelease">
                                                <button type="button" class="btn artist-sec-btn"><i class="fa-solid fa-plus"></i>Add Artist</button>
                                            </a>
                                            <?php endif; ?>
                                        </div>

                                        <!-- Add artist modals -->

                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="display-artist">Display Artist<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="display_artist" id="display-artist" value="<?php echo e($release->display_artist ?? ''); ?>" />
                                    </div>
                                </div>

                                <?php
                                $user = Auth::user();
                                $userRoles = null;
                                if ($user && $user->roles->isNotEmpty()) {
                                $role = $user->roles->first();
                                $userRoles = $role->name;
                                }
                                ?>

                                <?php if(!empty($userRoles) && $userRoles!="Super Admin"): ?>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Label<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="label_id" id="label_id" class="form-control">
                                            <option value="">Select Label</option>
                                            <?php $__currentLoopData = $lablesUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>" <?php if($release->label_id==$user->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($user->name)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <?php endif; ?>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Do you have UPC?<i class="fa-solid fa-circle-info"></i></label>
                                        <div class="main-form-radio d-flex justify-content-start gap-3">

                                            <div class="radio-btn">
                                                <input type="radio" value="1" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_yes"  
                                                <?php if($release->is_upc==1): ?> checked <?php endif; ?> />
                                                <label class="form-check-label" for="yes">Yes</label>
                                            </div>

                                            <div class="radio-btn">
                                                <input  type="radio" value="0" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_no" <?php if($release->is_upc==0): ?> checked <?php endif; ?> >
                                                <label class="form-check-label" for="no">No</label>
                                            </div>

                                        </div>
                                    </div>
                                </div>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label <?php if($release->is_upc==1): ?> required <?php endif; ?>" id="upc_label_req_album" for="upc">UPC/EAN<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="upc/ean" id="single_upc_number_album" name="upc_number"  value="<?php echo e($release->upc_number ?? ''); ?>"
                                        <?php if($release->upc_number): ?> required <?php else: ?> readonly disabled <?php endif; ?>
                                        />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cline">C-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line" class="form-control" placeholder="C-Line" id="cline" value="<?php echo e($release->c_line ?? ''); ?>" required />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cLineYear">C-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line_year" class="form-control" placeholder="C-Line Year" id="c_line_year" value="<?php echo e($release->c_line_year ?? ''); ?>" required />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pline">P-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line" class="form-control" placeholder="P-Line" id="pline" required  value="<?php echo e($release->p_line ?? ''); ?>" />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pLineYear">P-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line_year" class="form-control" placeholder="P-Line Year" id="pLineYear" required value="<?php echo e($release->p_line_year ?? ''); ?>" />
                                    </div>
                                </div>

                                <?php 
                                $releaseDate = date('Y-m-d');
                                if(!empty($release->release_date)){
                                    $date = new DateTime($release->release_date);
                                    $releaseDate =  $date->format('Y-m-d');
                                }
                               
                                ?>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="release_date">Release Date<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="date" class="form-control" placeholder="Release Date" id="release_date" name="release_date" required value="<?php echo e($releaseDate ?? ''); ?>" />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="main_genre">Main Genre<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="genre_id" id="albumgenre_id" class="form-control" required>
                                            <option value="">Select Genre</option>
                                            <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($genre->id); ?>" <?php if($release->genre_id==$genre->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($genre->title)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>


                                <?php 
                                if(!empty($release->genre_id)){
                                    $subgenres = getSubGenreByGenreId($release->genre_id);
                                }
                                ?> 

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="albumsubgenredata">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="sub_genre">Sub Genre<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                                            <option value="">Select Sub Genre</option>
                                            <?php if(!empty($subgenres)): ?> 
                                                <?php $__currentLoopData = $subgenres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subgenre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subgenre->id); ?>"  <?php if($release->subgenre_id==$subgenre->id): ?> selected <?php endif; ?>><?php echo e($subgenre->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>

                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">


                                <div class="form-group main-form">
                                    <label class="form-label required" for="lyricist">Composer
                                        <i class="fa-solid fa-circle-info"></i></label>

                                    <div class="sub-sec">
                                        <input type="text" class="form-control" placeholder="First Name" id="Composer" name="composer" required value="<?php echo e($release->composer ?? ''); ?>" />

                                        <input type="text" name="composer_lastname" class="form-control" placeholder="Last Name" id="composer_lastname" value="<?php echo e($release->composer_lastname ?? ''); ?>" required />
                                    </div>
                                </div>

                            </div>


                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label required" for="lyricist">Lyricist<i class="fa-solid fa-circle-info"></i></label>
                                    <div class="sub-sec">
                                        <input type="text" name="lyricist_firstname" class="form-control" placeholder="First" id="lyricist_firstname" required value="<?php echo e($release->lyricist_firstname ?? ''); ?>" />

                                        <input type="text" name="lyricist_lastname" class="form-control" placeholder="Last" id="lyricist_lastname"  required value="<?php echo e($release->lyricist_lastname ?? ''); ?>" />
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="catalogue_no">Catalogue Number<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" name="cat_number" class="form-control" placeholder="Catalogue Number" id="cat_number" value="<?php echo e($release->cat_number ?? ''); ?>" />

                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="fe_artist">Featured Artist<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="<?php echo e($release->feature_artist ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="fe_artist">Is Instrumental?<i class="fa-solid fa-circle-info"></i></label>

                                    <div class="main-form-radio d-flex justify-content-start gap-3">

                                        <div class="radio-btn">
                                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_yes" value="1" 
                                            <?php if($release->is_instrumental==1): ?> selected <?php endif; ?>
                                             />
                                            <label class="form-check-label" for="is_yes">Yes</label>
                                        </div>

                                        <div class="radio-btn">
                                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_no" checked value="0" 
                                            <?php if($release->is_instrumental==0): ?> selected <?php endif; ?>  />
                                            <label class="form-check-label" for="is_no">No</label>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="actor">Actor<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Actor" id="actor" name="actor" value="<?php echo e($release->actor ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="conductor">Conductor<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Conductor" id="conductor" name="conductor" value="<?php echo e($release->conductor ?? ''); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="remixer">Remixer<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Remixer" id="remixer" name="remixer" value="<?php echo e($release->remixer ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="arranger">Arranger<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Arranger" id="arranger" name="arranger" value="<?php echo e($release->arranger ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">


                                    <label class="form-label sub-label" for="start">CRBT (Start Time)</label>
                                    <input class="form-control" type="time" class="form-control" placeholder="08:30" id="crbt_start_time" name="crbt_start_time" value="<?php echo e($release->crbt_start_time ?? ''); ?>" />


                                </div>
                            </div>




                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="copyright_fe">Copyright<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Copyright" id="copyright_fe" name="copyrights" value="<?php echo e($release->copyrights ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="orchestra">Orchestra<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Orchestra" id="orchestra" name="orchestra" value="<?php echo e($release->orchestra ?? ''); ?>" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="parental_warn">Parental Warning Type<i class="fa-solid fa-circle-info"></i></label>

                                    <select name="parental_warning_type" id="parental_warning_type" class="form-control">

                                        <option value="NotExplicit" 
                                        <?php if($release->parental_warning_type=="NotExplicit" ): ?> selected <?php endif; ?>
                                        >NotExplicit
                                    </option>
                                        <option value="Explicit"  
                                        <?php if($release->parental_warning_type=="Explicit" ): ?> selected <?php endif; ?>>Explicit</option>
                                        <option value="ExplicitContentEdited"  
                                        <?php if($release->parental_warning_type=="ExplicitContentEdited" ): ?> selected <?php endif; ?>>ExplicitContentEdited</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="price_tiers">Price Tiers (For iTunes Only)<i class="fa-solid fa-circle-info"></i></label>
                                    <select name="price_tier" id="price_tier" class="form-control">
                                        <option value="">Select Price Tier</option>
                                        <?php $__currentLoopData = release_prices_tires(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price_key => $price_val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($price_key); ?>" <?php if($release->price_tier==$price_key): ?> selected <?php endif; ?>>
                                            <?php echo e($price_val); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>


                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form">
                                    <label class="form-label" for="release_desc">Release Descriptions</label>
                                    <textarea style="height: 131px;" name="description" id="description" class="form-control"><?php echo e($release->description); ?></textarea>

                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form d-flex gap-2">
                                    <button type="submit" class="btn main-next-btn">Next</button>
                                </div>
                            </div>
                        </div>
                        <!-- </form> -->
                </div>
                </form>



            </div>

        </div>
    </div>
    </div>

</section>



<script type="text/javascript">
    $(document).ready(function() {

        $("#frmReleaseStepAlbum1").validate({
            rules: {
                title: {
                    required: true
                },
                artists: {
                    required: true
                },
                p_line: {
                    required: true
                },
                c_line: {
                    required: true
                },
                p_line_year: {
                    required: true
                },
                c_line_year: {
                    required: true
                },
                release_date: {
                    required: true
                },
                composer: {
                    required: true
                },
                composer_lastname: {
                    required: true
                },

                genre_id: {
                    required: true
                },

                subgenre_id: {
                    required: true
                },

                lyricist_firstname: {
                    required: true
                },
                lyricist_lastname: {
                    required: true
                },



            },
            messages: {
                title: {
                    required: "Title field is required"
                },
                artists: {
                    required: "Artists field is required"
                },
                p_line: {
                    required: "P Line field is required"
                },

                c_line: {
                    required: "C Line field is required"
                },

                p_line_year: {
                    required: "P Line Year field is required"
                },

                c_line_year: {
                    required: "C Line Year field is required"
                },

                release_date: {
                    required: "Release Date field is required"
                },
                composer: {
                    required: "Composer First Name field is required"
                },
                composer_lastname: {
                    required: "Composer Last Name field is required"
                },
                genre_id: {
                    required: "Genre field is required"
                },
                subgenre_id: {
                    required: "Sub Genre field is required"
                },
                lyricist_firstname: {
                    required: "Lyricist First Name field is required"
                },
                lyricist_lastname: {
                    required: "Lyricist Last Name field is required"
                },
            },
            submitHandler: function(form) {
                $('#frm_submit_loading').show();
                form.submit();
            },
            invalidHandler: function(event, validator) {
                $('#frm_submit_loading').hide();;
            }
        });





        let isAlbumAppleClickTriggered = false;
        $('#release_album_apple_art_work').click(function() {
            if (!isAlbumAppleClickTriggered) {
                isAlbumAppleClickTriggered = true;
                $('#album_apple_art_file').trigger('click');
                isAlbumAppleClickTriggered = false;
            }
        });


        let isAlbumArtWorkClickTriggered = false;
        $('#release_album_art_work').click(function() {
            if (!isAlbumArtWorkClickTriggered) {
                isAlbumArtWorkClickTriggered = true;
                $('#album_artwork_file').trigger('click');
                isAlbumArtWorkClickTriggered = false;
            }
        });


        $('#album_artwork_file').on('change', function(e) {
            var file = e.target.files[0];
            if (file && file.type.startsWith('image/')) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('.albumartworkpreviewimage').css({
                        'background-image': 'url("' + event.target.result + '")'
                    });
                    $('#album_chose-file-content_artwork').hide();
                    $('#album_error-message').hide();
                }
                reader.readAsDataURL(file);
            } else {
                alert('Please select a valid image file');
                return false;
            }
        });

        $('#album_apple_art_file').on('change', function(e) {
            var file = e.target.files[0];
            if (file && file.type.startsWith('image/')) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('.albumappleartworkpreviewimage').css({
                        'background-image': 'url("' + event.target.result + '")'
                    });
                    $('#album_apple_chose-file-content_artwork').hide();
                }
                reader.readAsDataURL(file);
            } else {
                alert('Please select a valid image file');
                return false;
            }
        });



        $('#frmReleaseStepAlbum1').submit(function(e) {
            // Get the file input element
            var fileInput = $('#album_artwork_file')[0];
            var file = fileInput.files[0];

            // Clear previous error messages
            $('#album_error-message').hide();
            // Check if a file was selected
            if (!file) {
                $('#album_error-message').text('Art Work field is required').show();
                e.preventDefault(); // Prevent form submission
                return false;
            }

        });


        $(document).on('click', '#albumReleaselyricsSubmit', function() {
            var file = $('#albumReleaseLyricFile')[0].files[0]; // Get the file
            var formData = new FormData(); // Create FormData object
            formData.append('file', file); // Append the file to FormData
            formData.append('_token', "<?php echo e(csrf_token()); ?>"); // Append CSRF token to FormData

            $.ajax({
                url: "<?php echo e(route('upload.release.single.lyrics')); ?>",
                type: 'POST',
                data: formData, // Send FormData
                contentType: false, // Don't set content type because FormData sets it automatically
                processData: false, // Don't process data because it's a file upload
                xhr: function() {
                    var xhr = new XMLHttpRequest();
                    xhr.upload.addEventListener('progress', function(e) {
                        if (e.lengthComputable) {
                            $("#addAlbumLyrics").hide();
                            $('#addAlbumLyrics').modal('hide');
                            var percent = (e.loaded / e.total) * 100;
                            $('#albumprogressBar').css('width', percent + '%');
                            $('#albumprogressBar').text(Math.round(percent) + '%');
                        }
                    }, false);

                    return xhr;
                },
                success: function(response) {
                    // alert('File uploaded successfully!');
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while uploading the file');
                }
            });
        });

        $("#addAlbumArtistRelease").click(function() {
            $.ajax({
                url: "<?php echo e(route('release.artist.create')); ?>",
                type: "POST",
                data: {
                    'flag': 'release',
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(html) {
                    window.location.href = "<?php echo e(route('artists.create')); ?>";
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("#albumgenre_id").change(function() {
            var genre_id = $(this).val();
            $.ajax({
                url: "<?php echo e(route('release.subgenre')); ?>",
                type: "POST",
                data: {
                    'genre_id': genre_id,
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(html) {
                    html = html.replace("<strong>", "<label>");
                    html = html.replace("</strong>", "</label>");
                    $("#albumsubgenredata").html(html);
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("input:radio.albumReleaseUPC").click(function() {
            if ($('input:radio.albumReleaseUPC:checked').val() == "1") {
                $('#single_upc_number_album').prop('disabled', false);
                $('#single_upc_number_album').removeAttr('readonly');
                $('#single_upc_number_album').attr('required', true);
                $('#upc_label_req_album').addClass('required');
            }

            if ($('input:radio.albumReleaseUPC:checked').val() == "0") {
                $('#single_upc_number_album').val('');
                $('#single_upc_number_album').prop('disabled', true);
                $('#single_upc_number_album').attr('readonly', true);
                $('#single_upc_number_album').removeAttr('required', true);
                $('#upc_label_req_album').removeClass('required');
            }

        });







    });


    let islyricsClickTriggered = false;
    $(document).on('click', '#releaseuploadlyrics', function() {
        if (!islyricsClickTriggered) {
            islyricsClickTriggered = true;
            $('#albumReleaseLyricFile').trigger('click');
            islyricsClickTriggered = false;
        }
    });



    $("input:radio[name=is_instrumental]").click(function() {
        if ($('input:radio[name=is_instrumental]:checked').val() == "0") {
            $('#lyricistData').show();
        }
        if ($('input:radio[name=is_instrumental]:checked').val() == "1") {
            $('#lyricistData').hide();
        }
    });

    $("input:radio[name=is_upc]").click(function() {
        if ($('input:radio[name=is_upc]:checked').val() == "1") {
            $('#single_upc_number').prop('disabled', false);
            $('#single_upc_number').removeAttr('readonly');
            $('#single_upc_number').attr('required', true);
            $('#upc_label_req').addClass('required');
        }
        if ($('input:radio[name=is_upc]:checked').val() == "0") {
            $('#single_upc_number').val('');
            $('#single_upc_number').prop('disabled', true);
            $('#single_upc_number').attr('readonly', true);
            $('#single_upc_number').removeAttr('required', true);
            $('#upc_label_req').removeClass('required');
        }
    });


    $("#genre_id").change(function() {
        var genre_id = $(this).val();
        $.ajax({
            url: "<?php echo e(route('release.subgenre')); ?>",
            type: "POST",
            data: {
                'genre_id': genre_id,
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            cache: false,
            success: function(html) {
                html = html.replace("<strong>", "<label>");
                html = html.replace("</strong>", "</label>");
                $("#subgenredata").html(html);
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });


    $("#addArtistRelease").click(function() {
        $.ajax({
            url: "<?php echo e(route('release.artist.create')); ?>",
            type: "POST",
            data: {
                'flag': 'release',
                "_token": "<?php echo e(csrf_token()); ?>"
            },
            cache: false,
            success: function(html) {
                window.location.href = "<?php echo e(route('artists.create')); ?>";
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });
</script>

<?php
Session::forget('release_form_show');
?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/releases/edit-album.blade.php ENDPATH**/ ?>