<?php $__env->startSection('content'); ?>

<section class="right-sidebar" id="sidebarRight">
        <div class="view-release-sec">
            <div class="view-release">
                <div class="view-release-heading">
                    <h6>View Genre</h6>
                </div>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['create-genre'])): ?>
                <div class="view-all-release-search">
                    <a href="<?php echo e(route('genre.create')); ?>"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
                </div>
                <?php endif; ?>


            </div>

            <div class="viewReleases-main-sec">
                <table class="table table-bordered">
                    <thead>
                      <tr>
                      <th>No</th>
                        <th>Genre Name</th>
                        <th>Genre Description</th>
                        <th>Genre Status</th>
                        <th width="280px">Action</th>
                       </tr>
                    </thead>
                    <tbody>
                     
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(++$i); ?></td>
                        <td><?php echo e($genre->title); ?></td>
                        <td><?php echo e($genre->description); ?></td>
                        <td>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-genre'])): ?>
                        <input  type="checkbox" id="genre_<?php echo e($genre->id); ?>" class="form-check-input genreStatus" name="genreStatus"  <?php if($genre->status==1): ?> checked <?php endif; ?> />
                        <?php endif; ?>


                        <?php if(!empty($genre->status)): ?>
                            <label id="genreStatus_<?php echo e($genre->id); ?>" class="badge bg-success">Active</label>
                            <?php else: ?>
                            <label id="genreStatus_<?php echo e($genre->id); ?>" class="badge bg-danger">Disabled</label>
                        <?php endif; ?>
                        </td>
                        <td>

                           <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-genre'])): ?>
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('genre.edit',$genre->id)); ?>"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['delete-genre'])): ?>
                            <!-- Delete Button -->
                            <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-genre-id="<?php echo e($genre->id); ?>">
                                <i class="fa-solid fa-trash"></i> Delete
                            </button>
                            <?php endif; ?>


                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     
                    </tbody>
                  </table>
                  <?php echo $data->links('pagination::bootstrap-5'); ?>



                  <!-- Delete Confirmation Modal -->
                    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    Are you sure you want to delete this genre?
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                    <form id="deleteForm" method="POST" action="<?php echo e(route('genre.destroy', '')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>



            </div>
        </div>
    </section>
   



    <script>
    $(document).ready(function(){
        // Handle the checkbox change (genre status toggle)
        $(".genreStatus").change(function(){
            var genreStr = $(this).attr('id');
            var genreArr = genreStr.split("_");
            var genreId = genreArr[1];

            $.ajax({
                url: "<?php echo e(route('genre.status.update')); ?>",
                type: "POST",
                data: {genreId : genreId, "_token": "<?php echo e(csrf_token()); ?>" },
                cache: false,
                success: function(requestResponse){
                    var genreStatusId = "genreStatus_" + genreId;
                    if(requestResponse == "disabledGenre"){
                        $(this).prop('checked', false);
                        $("#" + genreStatusId).removeClass("bg-success").addClass("bg-danger").text("Disabled");
                    } else if(requestResponse == "activeGenre"){
                        $(this).prop('checked', true);
                        $("#" + genreStatusId).removeClass("bg-danger").addClass("bg-success").text("Active");
                    }
                },
                error: function(response){
                    alert('Something went wrong!');
                    console.log(response);
                }
            });
        });

        // Handle delete button click to set the correct form action
        $('#deleteModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var genreId = button.data('genre-id');
            var actionUrl = "<?php echo e(route('genre.destroy', ':id')); ?>".replace(':id', genreId);
            $('#deleteForm').attr('action', actionUrl);
        });
    });
</script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/genres/index.blade.php ENDPATH**/ ?>