<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">

    <form action="<?php echo e(route('release.track.save',$release->id)); ?>" method="post" enctype="multipart/form-data" id="frmReleaseStep2">
    <?php echo csrf_field(); ?>
        <div class="modal-header">
          <h5 class="modal-title" id="staticBackdropLabel">Add New Track</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="row">

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Disc:</label>
                <input type="text" name="disc" disabled class="form-control" value="1"/>
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Tracks#:</label>
                <input type="number" name="serial_number" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Artist:</label>
                <input type="text" name="artists" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Display Artist:</label>
                <input type="text" name="display_artist" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Featured Artist:</label>
                <input type="text" name="feature_artist" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Title:</label>
                <input type="text" name="title" class="form-control" />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Mix Version:</label>
                <input type="text" name="mix_version" class="form-control" />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Choose Remixer:</label>
                <select name="remixer" id="remixer" class="form-control" >
                  <option value="">Select Remixer</option>
                  <?php $__currentLoopData = getTrackRemixers(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remixer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($remixer); ?>"><?php echo e($remixer); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6" id="remixerData">
            <div class="form-group">
                <label>OR Enter Remixer(s):</label>
                  <a href="javascript:void(0);" id="addremixerbutton">
                    <button class="btn btn-success" type="button">
                    <i class="fa fa-plus" aria-hidden="true"></i>
                    </button>
                  </a>
                <input type="text" name="remixer_list[]" class="form-control" />
            </div>
          </div>

        
          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Orchestra:</label>
                <input type="text" name="orchestra" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Arranger:</label>
                <input type="text" name="arranger" class="form-control" />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Actor:</label>
                <input type="text" name="actor" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Conductor:</label>
                <input type="text" name="conductor" class="form-control" />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label class="required">Composer:</label>
                <input type="text" name="composer" class="form-control" required />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Main Genre:</label>
                <select name="genre_id" id="genre_id" class="form-control">
                  <option value="">Select Genre</option>
                  <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($genre->id); ?>"><?php echo e($genre->title); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6" id="trackSubGenreData">
            <div class="form-group">
                <label>Sub Genre:</label>
                <select name="subgenre_id" id="subgenre_id" class="form-control">
                  <option value="">Select Sub Genre</option>
                </select>
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Publisher:</label>
                <input type="text" name="publisher" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Contributors:</label>
                <input type="text" name="contributors" class="form-control" />
            </div>
          </div>

          <p>Do you have ISRC?:</p>
          <br />

          <div class="col-xs-6 col-sm-6 col-md-6 d-flex">
          
          <div class="form-group">
            <input type="radio" name="have_isrc" value="1" class="form-check-input"  />
                <label>Yes:</label>
            </div>

            <div class="form-group">
            <input type="radio" checked name="have_isrc" value="0" class="form-check-input" />
                <label>No:</label>
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6" style="display:none;" id="isrc_main_div">
            <div class="form-group">
                <label>ISRC Number:</label>
                <input type="text" name="isrc_number" class="form-control" />
            </div>
          </div>

          <div class="col-xs-12 col-sm-12 col-md-12">
          <label>Album Only:</label>
          <div class="form-group d-flex">
         
              <input type="checkbox" name="sold_with_album" class="form-check-input"  value="1" />
              <p>Yes, this track can only be sold with full album</p>
            </div>
          </div>

          <div class="col-xs-12 col-sm-12 col-md-12">
          <div class="form-group d-flex">
              <input type="checkbox" name="explicit" class="form-check-input"  value="1" />
              <p>Explicit</p>
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Start Time:</label>
                <input type="time" name="start_time" class="form-control" />
            </div>
          </div>


          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>End Time:</label>
                <input type="time" name="end_time" class="form-control" />
            </div>
          </div>

          <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Price Tiers(For ITunes Only):</strong>
               <select name="price_tier" id="price_tier" class="form-control">
                <option value="">Select Price Tier</option>
                <?php $__currentLoopData = release_prices_tires(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price_key => $price_val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($price_key); ?>" <?php if($release->price_tier == $price_key): ?> selected <?php endif; ?>>
                        <?php echo e($price_val); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                </select>
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <label>Audio File(Must be wav - 44.1 kHz):</label>
                <input type="file" name="my_audio_files[]" class="form-control" multiple />
            </div>
          </div>

          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
        </div>

      </form>

    </div>
  </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $("#frmReleaseStep2").validate({
                rules: {
                  composer: {
                        required: true
                    },  
                },
                messages: {
                  composer: {
                        required: "Composer field is required"
                    },
                }
            });
        });


        $(document).on("change", '#genre_id', function(event) { 
          var genre_id = $(this).val();
          $.ajax({
                url: "<?php echo e(route('release.subgenre')); ?>",
                type: "POST",
                data: {'genre_id' : genre_id,"_token": "<?php echo e(csrf_token()); ?>" },
                cache: false,
                success: function(html){
                    // $("#trackSubGenreData").html(html.replace("strong", "label"));
                    html = html.replace("<strong>", "<label>");
                    html = html.replace("</strong>", "</label>");
                    $("#trackSubGenreData").html(html);
                },
                error: function (textStatus, errorThrown) {
                   alert('Something went wrong!');
                   return false;
                }
            });
        });

        // $(document).on("change", '#remixer', function(event) { 
        //   var remixer = $(this).val();
        //   if(remixer == ""){
        //     $('#remixerData').show();
        //   }else{
        //     $('#remixerData').hide();
        //   }
        // });
    </script><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/releases/create_track.blade.php ENDPATH**/ ?>