@extends('layouts.app')

@section('content')

<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Users</h6>
            </div>

            @can('edit-user')
            <div class="view-all-release-search">
                <a href="{{ route('users.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan
        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>S#</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Roles</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        @forelse ($users as $user)
                    <tr>
                        <th scope="row">{{ $loop->iteration }}</th>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>
                            <ul>
                                @forelse ($user->getRoleNames() as $role)
                                <li>{{ $role }}</li>
                                @empty
                                @endforelse
                            </ul>
                        </td>

                        <td>
                            <form action="{{ route('users.destroy', $user->id) }}" method="post">
                                @csrf
                                @method('DELETE')

                              
                                    @if (Auth::user()->hasRole('Super Admin'))

                                    <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Edit</a>

                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Do you want to delete this user?');"><i class="bi bi-trash"></i> Delete</button>


                                    @elseif(Auth::user()->hasRole('Sub Labels'))


                                    @can('edit-sublabel')
                                    <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Edit</a>
                                    @endcan


                                    @can('delete-sublabel')
                                        @if (Auth::user()->id!=$user->id)
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Do you want to delete this user?');"><i class="bi bi-trash"></i> Delete</button>
                                        @endif
                                    @endcan



                                    @else

                                    @can('edit-user')
                                    <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary btn-sm"><i class="bi bi-pencil-square"></i> Edit</a>
                                    @endcan


                                    @can('delete-user')
                                        @if (Auth::user()->id!=$user->id)
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Do you want to delete this user?');"><i class="bi bi-trash"></i> Delete</button>
                                        @endif
                                    @endcan

                                    @endif
                             

                            </form>
                        </td>
                    </tr>
                    @empty
                    <td colspan="5">
                        <span class="text-danger">
                            <strong>No User Found!</strong>
                        </span>
                    </td>
                    @endforelse

                    </tr>


                </tbody>
            </table>

            {!! $users->links('pagination::bootstrap-5') !!}




            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            Are you sure you want to delete this genre?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <form id="deleteForm" method="POST" action="{{ route('genre.destroy', '') }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>




        </div>
    </div>
</section>



@endsection