@extends('layouts.app')

@section('content')


<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add User</h6>
        </div>


        <div class="releases-sec-main">


            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            @if(!empty($userFlag) &&  $user_roles =="Sub Label")
            <form action="{{ route('sublabel.store') }}" method="post" class="add-releses-form" id="frmAddUser">
            @elseif(!empty($userFlag) &&  $user_roles =="Label")
            <form action="{{ route('label.store') }}" method="post" class="add-releses-form" id="frmAddUser">
            @else
            <form action="{{ route('users.store') }}" method="post" class="add-releses-form" id="frmAddUser">
            @endif

                @csrf
                <div class="row">


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the user."></i>
                            </label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" />
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Email Address
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the email of the user."></i>
                            </label>
                            <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}" />
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Password
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the password of the user."></i>
                            </label>
                            <input type="password" class="form-control" id="password" name="password" />
                        </div>
                    </div>



                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Confirm Password
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the Confirm password of the user."></i>
                            </label>
                            <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" />
                        </div>
                    </div>

                    @if(!empty($userFlag))
                    <input type="hidden"   name="roles[]"  value="{{ $user_roles ?? 'User' }}"/>
                    @else
                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Roles
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select the roles of the user."></i>
                            </label>
                            <select class="form-select @error('roles') is-invalid @enderror" multiple aria-label="Roles" id="roles" name="roles[]">
                                @forelse ($roles as $role)

                                @if ($role!='Super Admin')
                                <option value="{{ $role }}" {{ in_array($role, old('roles') ?? []) ? 'selected' : '' }}>
                                    {{ $role }}
                                </option>
                                @else
                                @if (Auth::user()->hasRole('Super Admin'))
                                <option value="{{ $role }}" {{ in_array($role, old('roles') ?? []) ? 'selected' : '' }}>
                                    {{ $role }}
                                </option>
                                @endif
                                @endif

                                @empty

                                @endforelse
                            </select>
                        </div>
                    </div>
                    @endif


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>


<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddUser").validate({
            rules: {
                name: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                password: {
                    required: true,
                },
                password_confirmation: {
                    required: true,
                    equalTo: "#password"

                },
                "roles[]": {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: "User Name field is required"
                },
                email: {
                    required: "Email field is required",
                    email: "Invalid Email!"
                },

                password: {
                    required: "User password field is required"
                },

                password_confirmation: {
                    required: "User Confirm password field is required",
                    equalTo: "Passwords do not match"
                },

                "roles[]": {
                    required: "User roles field is required"
                },
            }
        });
    });
</script>


@endsection