@extends('layouts.app')

@section('content')



<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View User's DSP</h6>
            </div>

            @can(['create-userdsp'])
            <div class="view-all-release-search">
                <a href="{{ route('userdsp.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan

        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>User Name</th>
                        <th>DSP Name</th>
                        <th>Country Names</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($data as $key => $userdsp)

                    @php
                    $countries = null;
                    if(!empty(json_decode($userdsp->country_ids))){

                    foreach(json_decode($userdsp->country_ids) as $country){
                    $countryName = getCountryById($country)->code ?? null;
                    if($countries){
                    $countries.= ",".$countryName;
                    }else{
                    $countries = $countryName;
                    }
                    }
                    }else{
                    $countries = null;
                    }
                    @endphp

                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ getUserById($userdsp->user_id)->name ?? '' }}</td>
                        <td>{{ getDSPById($userdsp->dsp_id)->name ?? '' }}</td>
                        <td>{{ $countries }}</td>

                        <td>
                            <a class="btn btn-primary btn-sm" href="{{ route('userdsp.edit',$userdsp->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            <form method="POST" action="{{ route('userdsp.destroy', $userdsp->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
            {!! $data->links('pagination::bootstrap-5') !!}
        </div>
    </div>
</section>

@endsection