@extends('layouts.app')

@section('content')



<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Permissions</h6>
        </div>
        <div class="releases-sec-main">
            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

    
                <form action="{{ route('roles.update', $role->id) }}" method="post" class="add-releses-form" id="frmAddRoles">
                    @csrf
                    @method("PUT")
                <div class="row">


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the role."></i>
                            </label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $role->name }}" />
                        </div>
                    </div>

    
                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Permissions
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select the permissions of the role."></i>
                            </label>
                            <select class="form-select @error('permissions') is-invalid @enderror" multiple aria-label="Permissions" id="permissions" name="permissions[]" style="height: 210px;">
                                @forelse ($permissions as $permission)
                                    <option value="{{ $permission->id }}" {{ in_array($permission->id, $rolePermissions ?? []) ? 'selected' : '' }}>
                                      

                                        {{ ucwords(str_replace("-"," ",$permission->name)) }}
                                    </option>
                                @empty

                                @endforelse
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>


<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddRoles").validate({
            rules: {
                name: {
                    required: true
                },
                
                "permissions[]": {
                    required: true, 
                },
            },
            messages: {
                name: {
                    required: "Role Name field is required"
                },
               
                "permissions[]": {
                    required: "Role Permission field is required"
                },
            }
        });
    });
</script>

   
@endsection