@extends('layouts.app')

@section('content')


<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add DSP</h6>
        </div>

        <div class="releases-sec-main">

            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="add-releses-form" method="POST" action="{{ route('dsp.store') }}" id="frmAddDSP">
                @csrf

                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="dsp">DSP Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the DSP."></i>
                            </label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" />
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label required" for="status">DSP Status
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select whether the DSP is active or disabled."></i>
                            </label>
                            <select name="status" id="status" class="form-control">
                                <option @if(old('status')==1) selected @endif value="1">Active</option>
                                <option @if(old('status')==0) selected @endif value="0">Disabled</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddDSP").validate({
            rules: {
                name: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                name: {
                    required: "DSP Name field is required"
                },
                status: {
                    required: "DSP Status field is required"
                },
            }
        });
    });
</script>




@endsection
