@extends('layouts.app')

@section('content')


<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Countries</h6>
            </div>

            @can('create-country')
            <div class="view-all-release-search">
                <a href="{{ route('country.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan
        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Country Name</th>
                        <th>Country Code</th>
                        <th>Country Status</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $key => $country)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $country->name }}</td>
                        <td>{{ $country->code }}</td>
                        <td>

                            @can('edit-country')
                            <input type="checkbox" id="country_{{ $country->id }}" class="form-check-input countryStatus" name="countryStatus" @if($country->status==1) checked @endif />
                            @endcan

                            @if(!empty($country->status))
                            <label id="countryStatus_{{ $country->id }}" class="badge bg-success">Active</label>
                            @else
                            <label id="countryStatus_{{ $country->id }}" class="badge bg-danger">Disabled</label>
                            @endif
                        </td>
                        <td>

                            @can('edit-country')
                            <a class="btn btn-primary btn-sm" href="{{ route('country.edit',$country->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            @endcan


                            @can('delete-country')
                            <form method="POST" action="{{ route('country.destroy', $country->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                            @endcan

                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>

            {!! $data->links('pagination::bootstrap-5') !!}

        </div>
    </div>
</section>

<script>
    $(document).ready(function() {
        $(".countryStatus").change(function() {
            var countryStr = $(this).attr('id');
            var countryArr = countryStr.split("_");
            var countryId = countryArr[1];

            $.ajax({
                url: "{{route('country.status.update')}}",
                type: "POST",
                data: {
                    countryId: countryId,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    var countryStatusId = "countryStatus_" + countryId;

                    if (requestResponse == "disabledCountry") {
                        $(this).prop('checked', false);
                        $("#" + countryStatusId).removeClass("bg-success");
                        $("#" + countryStatusId).addClass("bg-danger");
                        $("#" + countryStatusId).text("Disabled");
                    } else if (requestResponse == "activeCountry") {
                        $(this).prop('checked', true);
                        $("#" + countryStatusId).addClass("bg-success");
                        $("#" + countryStatusId).removeClass("bg-danger");
                        $("#" + countryStatusId).text("Active");
                    }

                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });
    });
</script>



{{--

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Counries Management</h2>
        </div>

        <div class="pull-right">
            <a class="btn btn-success mb-2" href="{{ route('country.create') }}"><i class="fa fa-plus"></i> Create New Country</a>
</div>

</div>
</div>

@session('success')
<div class="alert alert-success" role="alert">
    {{ $value }}
</div>
@endsession


<table class="table table-bordered">
    <tr>
        <th>No</th>
        <th>Country Name</th>
        <th>Country Code</th>
        <th>Country Status</th>
        <th width="280px">Action</th>
    </tr>
    @foreach ($data as $key => $country)
    <tr>
        <td>{{ ++$i }}</td>
        <td>{{ $country->name }}</td>
        <td>{{ $country->code }}</td>
        <td>
            <input type="checkbox" id="country_{{ $country->id }}" class="form-check-input countryStatus" name="countryStatus" @if($country->status==1) checked @endif />

            @if(!empty($country->status))
            <label id="countryStatus_{{ $country->id }}" class="badge bg-success">Active</label>
            @else
            <label id="countryStatus_{{ $country->id }}" class="badge bg-danger">Disabled</label>
            @endif
        </td>
        <td>

            <a class="btn btn-primary btn-sm" href="{{ route('country.edit',$country->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
            <form method="POST" action="{{ route('country.destroy', $country->id) }}" style="display:inline">
                @csrf
                @method('DELETE')
                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
            </form>
        </td>
    </tr>
    @endforeach
</table>

{!! $data->links('pagination::bootstrap-5') !!}

<script>
    $(document).ready(function() {
        $(".countryStatus").change(function() {
            var countryStr = $(this).attr('id');
            var countryArr = countryStr.split("_");
            var countryId = countryArr[1];

            $.ajax({
                url: "{{route('country.status.update')}}",
                type: "POST",
                data: {
                    countryId: countryId,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    var countryStatusId = "countryStatus_" + countryId;

                    if (requestResponse == "disabledCountry") {
                        $(this).prop('checked', false);
                        $("#" + countryStatusId).removeClass("bg-success");
                        $("#" + countryStatusId).addClass("bg-danger");
                        $("#" + countryStatusId).text("Disabled");
                    } else if (requestResponse == "activeCountry") {
                        $(this).prop('checked', true);
                        $("#" + countryStatusId).addClass("bg-success");
                        $("#" + countryStatusId).removeClass("bg-danger");
                        $("#" + countryStatusId).text("Active");
                    }

                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });
    });
</script>

--}}

@endsection