@extends('layouts.app')

@section('content')









<section class="right-sidebar" id="sidebarRight">
        <div class="add-artist-sec">
            <div class="artist-sec-heading">
                <h6>Edit Artist</h6>
            </div>
            <div class="artist-file-sec">
                <div class="row">
                    <div class=" col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-3">
                        <div class="choose-artist-mainbox">
                            <div class="file-icon">
                                <i class="fa-solid fa-plus"></i>
                            </div>
                            <h5>Create New Artist</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="artist-sec-main">


            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="artist-sec-form" method="POST" action="{{ route('artists.update', $artist->id) }}" id="frmAddArtist">
            @csrf
            @method('PUT')
                    <div class="row">
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label required" for="name">Name</label>
                                <input type="text" class="form-control"  id="name" name="name" value="{{ $artist->name ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label required" for="email">Email</label>
                                <input type="email" class="form-control"  name="email" id="email" value="{{ $artist->email ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="music">Sound Cloud</label>
                                <input type="text" class="form-control" id="sound_cloud" name="sound_cloud" value="{{ $artist->sound_cloud ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="twitter">Twitter</label>
                                <input type="text" class="form-control" id="twitter" name="twitter" value="{{ $artist->twitter ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="facebook">Facebook</label>
                                <input type="text" class="form-control" id="facebook" name="facebook" value="{{ $artist->facebook ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="instagram">Instagram</label>
                                <input type="text" class="form-control"  id="instagram" name="instagram" value="{{ $artist->instagram ?? '' }}" />
                            </div>
                        </div>
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="youtube">Youtube OAC</label>
                                <input type="text" class="form-control" id="youtube" name="youtube" value="{{ $artist->youtube ?? '' }}" />
                            </div>
                        </div>
                        {{--<div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="isrc">ISRC</label>
                                <input type="text" class="form-control" id="isrc" name="isrc" value="{{ old('isrc') }}">
                            </div>
                        </div>--}}
                        <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-4">
                            <div class="form-group artist-form">
                                <label class="form-label" for="website">Website</label>
                                <input type="text" class="form-control" id="website" name="website" value="{{ $artist->website ?? '' }}" />
                            </div>
                        </div>
                    </div>
                    <section class="sportify-main">
                        <div class="spotify-artist-page">
                            <div class="spotify-heading">
                                <h2>Spotify Artist Page</h2>
                            </div>
                            <div class="spotify-radio">
                                <div class="spotify-radio-head">
                                    <h6>is this artist on spotify already?</h6>
                                </div>
                                <div class="artist-spotify-radio">
                                    <div class="form-group artist-radio">
                                        <input type="radio" @if($artist->is_on_spotfy==1) checked @endif  name="is_on_spotfy" id="spotify-radioYes" value="1" />
                                        <label for="spotify-radioYes">Yes, i can provide a link</label>
                                    </div>
                                    <div class="form-group artist-radio">
                                        <input type="radio" @if($artist->is_on_spotfy==0) checked @endif  name="is_on_spotfy" id="spotify-radioNo" value="0" />
                                        <label for="spotify-radioNo">No, i need artist page created,(We will request a new artist page be created for you. you must update the page info here once live):</label>
                                    </div>
                                    <div class="form-group spotify-artist-link" id="spotifyArtistData" @if($artist->is_on_spotfy==0) style="display:none;" @endif >
                                        <label for="spotifyArtist">Spotify Artist Link</label>
                                        <input type="text" id="spotfy_link" name="spotfy_link" value="{{ $artist->spotfy_link }}" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="artist-cheaks-box">
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" name="ar-cheack" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                        </div>
                    </section>
                    <section class="sportify-main">
                        <div class="spotify-artist-page">
                            <div class="spotify-heading">
                                <h2>Apple Artist Page</h2>
                            </div>
                            <div class="spotify-radio">
                                <div class="spotify-radio-head">
                                    <h6>is this artist on Apple already?</h6>
                                </div>
                                <div class="artist-spotify-radio">
                                    <div class="form-group artist-radio">
                                        <input type="radio" @if($artist->is_on_apple==1) checked @endif  id="appleYes" name="is_on_apple" value="1" />
                                        <label for="appleYes">Yes, i can provide a link</label>
                                    </div>
                                    <div class="form-group artist-radio">
                                        <input type="radio"  @if($artist->is_on_apple==0) checked @endif id="appleNo" name="is_on_apple" value="0" >
                                        <label for="appleNo">No, i need artist page created,(We will request a new artist page be created for you. you must update the page info here once live):</label>
                                    </div>
                                    <div class="form-group spotify-artist-link" id="appleArtistData" @if($artist->is_on_apple==0) style="display:none;" @endif>
                                        <label for="appleArtist">Apple Artist Link</label>
                                        <input type="text" id="appleArtist" name="apple_link"  value="{{ $artist->apple_link }}" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="apple-artist-cheaks-box">
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" name="ar-cheack" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                            <div class="artist-check-main">
                                <div class="artist-image">
                                    <img src="{{ asset('assets/img/artist.png') }}" alt="Not found">
                                </div>
                                <div class="artist-cheks form-check">
                                    <label class="form-check-label" for="flexCheckDefault">Will Smith</label>
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                </div>
                            </div>
                        </div>
                        <div class="artist-btn-main">
                            <button type="submit" class="btn artist-submit-btn">Submit</button>
                        </div>  
                    </section>    
                </form>
            </div>
        </div>
    </section>


    <script type="text/javascript">
    $(document).ready(function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
        $("#frmAddArtist").validate({
            rules: {
                name: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
               
            },
            messages: {
                name: {
                    required: "Artist Name field is required"
                },
                email: {
                    required: "Artist email field is required",
                    email: "Artist email is invalid!"
                },
              
            }
        });
    });



$('input[type=radio][name=is_on_spotfy]').on('change', function() {
    if($(this).val() == 1){
        $('#spotifyArtistData').show();
    }else{
        $('#spotfy_link').val('');
        $('#spotifyArtistData').hide();
        
    }
});

$('input[type=radio][name=is_on_apple]').on('change', function() {
    if($(this).val() == 1){
        $('#appleArtistData').show();
    }else{
        $('#appleArtist').val('');
        $('#appleArtistData').hide();
    }
});

</script>











{{--
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Edit Artist</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('artists.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
        </div>
    </div>
</div>

@if (count($errors) > 0)
    <div class="alert alert-danger">
      <strong>Whoops!</strong> There were some problems with your input.<br><br>
      <ul>
         @foreach ($errors->all() as $error)
           <li>{{ $error }}</li>
         @endforeach
      </ul>
    </div>
@endif

<form method="POST" action="{{ route('artists.update', $artist->id) }}" id="frmUpdateArtist">
    @csrf
    @method('PUT')

    <div class="row">

    <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong class="required">Name:</strong>
                <input type="text" name="name" placeholder="Name" class="form-control" required value="{{ $artist->name }}"/>
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong class="required">Email:</strong>
                <input type="email" name="email" placeholder="Email" class="form-control" required value="{{ $artist->email }}" />
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Sound Cloud:</strong>
                <input type="text" name="sound_cloud" placeholder="Sound Cloud" class="form-control" value="{{ $artist->sound_cloud }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Twitter:</strong>
                <input type="text" name="twitter" placeholder="Twitter" class="form-control" value="{{ $artist->twitter }}">
            </div>
        </div>

        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Facebook:</strong>
                <input type="text" name="facebook" placeholder="Facebook" class="form-control" value="{{ $artist->facebook }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Instagram:</strong>
                <input type="text" name="instagram" placeholder="Instagram" class="form-control" value="{{ $artist->instagram }}">
            </div>
        </div>


        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Youtube:</strong>
                <input type="text" name="youtube" placeholder="Youtube" class="form-control" value="{{ $artist->youtube }}">
            </div>
        </div>



        <div class="col-xs-6 col-sm-6 col-md-6">
            <div class="form-group">
                <strong>Brand Camp:</strong>
                <input type="text" name="brandcamp" placeholder="Brand Camp" class="form-control" value="{{ $artist->brandcamp }}">
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Website:</strong>
                <input type="text" name="website" placeholder="Website" class="form-control" value="{{ $artist->website }}">
            </div>
        </div>

        

        <h3 class="p-3">Spotify Artist Page</h3>
        <strong>Is this artist on spotify already?:</strong>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio" name="is_on_spotfy"  class="form-check-input" value="1" @if($artist->is_on_spotfy == 1) checked @endif />
                <label>Yes, I can provide a link:</label>
                
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio"  name="is_on_spotfy"  class="form-check-input" value="0" @if($artist->is_on_spotfy == 0) checked @endif />
                <label>No, I need an artist page created,(We will request a new artist page be created for you. You must update the page info here once live):</label>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 mt-3"  id="spotifyArtistData" @if($artist->is_on_spotfy == 0) style="display:none;" @endif>
            <div class="form-group">
                <strong>Spotify Artist Link:</strong>
                <input type="text" name="spotfy_link" id="spotfy_link" placeholder="Spotfy Link" class="form-control" value="{{ $artist->id }}">
            </div>
        </div>


        <h3 class="p-3">Apple Artist Page</h3>
        <strong>Is this artist on Apple already?:</strong>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio" checked name="is_on_apple"  class="form-check-input" value="1" @if($artist->is_on_apple == 1) checked @endif />
                <label>Yes, I can provide a link:</label>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
            <input type="radio"  name="is_on_apple"  class="form-check-input" value="0" @if($artist->is_on_apple == 0) checked @endif>
                <label>No, I need an artist page created,(We will request a new artist page be created for you. You must update the page info here once live):</label>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12 mt-3"  id="appleArtistData" @if($artist->is_on_apple == 0) style="display:none;" @endif >
            <div class="form-group">
                <strong>Apple Artist Link:</strong>
                <input type="text" name="apple_link" id="apple_link" placeholder="Apple Link" class="form-control" value="{{ $artist->id }}">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Submit</button>
        </div>
    </div>
</form>

<script>
$('input[type=radio][name=is_on_spotfy]').on('change', function() {
    if($(this).val() == 1){
        $('#spotifyArtistData').show();

    }else{
        $('#spotifyArtistData').hide();

        $('#spotfy_link').val('');
       
    }
});

$('input[type=radio][name=is_on_apple]').on('change', function() {
    if($(this).val() == 1){
        $('#appleArtistData').show();
    }else{
        $('#appleArtistData').hide();
        $('#apple_link').val('');
    }
});

</script>

<script type="text/javascript">
    $(document).ready(function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmUpdateArtist").validate({
            rules: {
                name: {
                    required: true
                },
                email: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                name: {
                    required: "Artist Name field is required"
                },
                email: {
                    required: "Artist email field is required"
                },
                status: {
                    required: "Artist status field is required"
                },
            }
        });
    });
</script>--}}



@endsection
