<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Role::create(['name' => 'Super Admin']);
        $admin = Role::create(['name' => 'Admin']);
        $user = Role::create(['name' => 'User']);

        $admin->givePermissionTo([
            'create-user',
            'edit-user',
            'delete-user'
        ]);

        $user->givePermissionTo([
            'view-userdsp',
            'create-userdsp',
            'edit-userdsp',
            'delete-userdsp',
            'view-sublabel',
            'create-sublabel',
            'edit-sublabel',
            'delete-sublabel'
        ]);
    }
}
