<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'updated_by_user_role')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('updated_by_user_role');
            });
        }
        Schema::table('releases', function (Blueprint $table) {
            $table->string('updated_by_user_role')->nullable()->after('updated_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('updated_by_user_role');
        });
    }
};
