<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'p_line_year')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('p_line_year');
            });
        }

        Schema::table('releases', function (Blueprint $table) {
            $table->string('p_line_year')->nullable()->after('p_line');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('p_line_year');
        });
    }
};
