<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('dsps', 'status')) {
            Schema::table('dsps', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }


        Schema::table('dsps', function (Blueprint $table) {
            $table->boolean('status')->default(false)->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dsps', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};
