<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;

class Release extends Model
{
    use HasFactory;

    public const DISABLED = 0;
    public const ACTIVE = 1;

    /**
     * The attributes that are mass assignable.
     *	
     * @var array
     */
    protected $fillable = [
        'lang',
        'artists',
        'display_artist',
        'feature_artist',
        'remixer',
        'composer',
        'composer_lastname',
        'orchestra',
        'arranger',
        'actor',
        'conductor',
        'is_instrumental',
        'lyricist_firstname',
        'lyricist_lastname',
        'title',
        'label_id',
        'artwork',
        'apple_art',
        'release_type',
        'cat_number',
        'genre_id',
        'subgenre_id',
        'is_upc',
        'release_date',
        'upc_number',
        'release_date',
        'p_line',
        'c_line',
        'copyrights',
        'price_tier',
        'parental_warning_type',
        'description',
        'country_ids',
        'dsp_ids',
        'exclusive_on_shop',
        'exclusive_for',
        'on_itunes',
        'created_by',
        'updated_by',
        'status',
        'published_date',
        'sublabel_id',
        'p_line_year',
        'lyrics_duration',
        'lyrics_file',
        'lyric_urls',
        'crbt_end_time',
        'crbt_start_time',
        'isrc',
        'c_line_year',
        'created_by_user_role',
        'updated_by_user_role',
        'single_audio_file'
    ];
}
