<?php

namespace App\Http\Controllers;

use App\Models\Userdsp;
use App\Http\Requests\StoreUserdspRequest;
use App\Http\Requests\UpdateUserdspRequest;


use App\Models\Country;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Models\Dsp;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class UserdspController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:view-userdsp|create-userdsp|edit-userdsp|delete-userdsp', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-userdsp', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-userdsp', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-userdsp', ['only' => ['destroy']]);
    }


    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $data = Userdsp::latest()->paginate(50);
        return view('userdsp.index', compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        $users = User::get();
        $dsps = Dsp::where('status', Dsp::ACTIVE)->get();
        $countries = Country::where('status', Country::ACTIVE)->get();
        return view('userdsp.create', compact('users', 'dsps', 'countries'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreUserdspRequest $request)
    {
        user_logs();
        $input = $request->all();
        $user_id =  $input['user_id'];
        $dsp_id =  $input['dsp_id'];
        $userdspCount = Userdsp::where([
            ['user_id', $user_id],
            ['dsp_id', $dsp_id]
        ])->count();

        if (empty($userdspCount)) {
            $countries = json_encode($input['country_ids']);
            unset($input['country_ids']);
            $input['country_ids'] = $countries;
            Userdsp::create($input);
            return redirect()->route('userdsp.index')->with([
                'message' => 'User`s DSP created successfully',
                'alert-type' => 'success'
            ]);
        } else {
            return redirect()->route('userdsp.index')->with([
                'message' => 'User`s DSP already exist!',
                'alert-type' => 'error'
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Userdsp $userdsp)
    {
        user_logs();
        $userdsp = Userdsp::find($userdsp->id);
        return view('userdsp.show', compact('userdsp'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Userdsp $userdsp)
    {
        user_logs();
        $users = User::get();
        $dsps = Dsp::where('status', Dsp::ACTIVE)->get();
        $countries = Country::where('status', Country::ACTIVE)->get();
        $userdsp = Userdsp::find($userdsp->id);
        return view('userdsp.edit', compact('userdsp', 'users', 'dsps', 'countries'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateUserdspRequest $request, Userdsp $userdsp)
    {
        user_logs();


        $input = $request->all();

        $user_id =  $input['user_id'];
        $dsp_id =  $input['dsp_id'];

        $userdspCount = Userdsp::where([
            ['user_id', $user_id],
            ['dsp_id', $dsp_id],
            ['id', '!=', $userdsp->id]
        ])->count();

        if (empty($userdspCount)) {
            $countries = json_encode($input['country_ids']);
            unset($input['country_ids']);
            $input['country_ids'] = $countries;

            $dsp = Userdsp::find($userdsp->id);
            $dsp->update($input);
            return redirect()->route('userdsp.index')->with([
                'message' => 'User`s DSP updated successfully',
                'alert-type' => 'success'
            ]);
        } else {
            return redirect()->route('userdsp.index')->with([
                'message' => 'User`s DSP already exist!',
                'alert-type' => 'error'
            ]);
        }
    }


    public function userDspStatus(Request $request){
        $input = $request->all();
        $user_id =  $input['userId'];
        $dsp_id =  $input['dspId'];

        if(isset($input['userdsp_id'])){
            $userdspCount = Userdsp::where([
                ['user_id',$user_id],
                ['dsp_id',$dsp_id],
                ['id','!=',$input['userdsp_id']]
                ])->count();

        }else{

            $userdspCount = Userdsp::where([
                ['user_id',$user_id],
                ['dsp_id',$dsp_id]
                ])->count();
        }
        
        if($userdspCount){
            return 'alreadyExist';
        }
        return "NotExist";
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Userdsp $userdsp)
    {
        user_logs();
        Userdsp::find($userdsp->id)->delete();
        return redirect()->route('userdsp.index')->with([
            'message' => 'User`s DSP delete successfully',
            'alert-type' => 'success'
        ]);
    }
}
