<?php

namespace App\Http\Controllers;

use App\Models\Artist;
use App\Http\Requests\StoreArtistRequest;
use App\Http\Requests\UpdateArtistRequest;
// use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class ArtistController extends Controller
{


    public function __construct(){
        $this->middleware('auth');
       $this->middleware('permission:view-artists|create-artists|edit-artists|delete-artists', ['only' => ['index','show']]);
       $this->middleware('permission:create-artists', ['only' => ['create','store']]);
       $this->middleware('permission:edit-artists', ['only' => ['edit','update']]);
       $this->middleware('permission:delete-artists', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $data = Artist::latest()->paginate(50);
        return view('artists.index',compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        return view('artists.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreArtistRequest $request)
    {
        user_logs();
        $input = $request->all();
        Artist::create($input);

        if (Session::has('releaseArtistCreate')) {

            return redirect()->route('release.create')
            ->with('success','Artist created successfully');
        }
        
        return redirect()->route('artists.index')
                        ->with('success','Artist created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Artist $artist)
    {
        user_logs();
        $dsp = Artist::find($artist->id);
        return view('artists.show',compact('dsp'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Artist $artist)
    {
        user_logs();
        $artist = Artist::find($artist->id);
        return view('artists.edit',compact('artist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateArtistRequest $request, Artist $artist)
    {
        user_logs();
        $input = $request->all();
        $artist = Artist::find($artist->id);
        $artist->update($input);
        return redirect()->route('artists.index')
                        ->with('success','Artist updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Artist $artist)
    {
        user_logs();
        Artist::find($artist->id)->delete();
        return redirect()->route('artists.index')
                        ->with('success','Artist deleted successfully');
    }
}
