<?php

use App\Models\Artist;
use App\Models\Country;
use App\Models\Dsp;
use App\Models\Genre;
use App\Models\Log;
use App\Models\Track;
use App\Models\Release;
use App\Models\SubGenre;
use App\Models\User;
use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Spatie\Permission\Models\Role;

if (! function_exists('user_logs')) {
    function user_logs(){

        /**
         * 
         * @return Logs for routes
         * 
         */
        $routeArray = app('request')->route()->getAction();
        if(!empty($routeArray['controller'])){
            $controllerAction = class_basename($routeArray['controller']);
            list($controller, $action) = explode('@', $controllerAction);
        }else{
            $controller = "Welcome page";
            $action = "Welcome page";
        }

        /**
         * 
         * Logs for users 
         * 
         */

 
        if (Auth::check()){
            $userName = Auth::user()->name;
            $user = Auth::user(); 
            // $roles = Role::pluck('name','name')->all();
            $userRole = $user->roles->pluck('name','id')->all();
            $role = '';
            foreach($userRole as $userRoleName){

                if(!empty($role)){
                    $role.= ",".$userRoleName;
                }else{
                    $role = $userRoleName;
                }  
            }
        }
        else{
            $userName = "Guest";
            $role = "Unknown";
        } 

        /**
         * 
         * Logs for user agents 
         * 
         */
        $ipAddress = getIPAaddress();
        $userAgent = json_encode($_SERVER);
        $model = New Log();
        $model->user = $userName;
        $model->user_role = $role;
        $model->ip_address = $ipAddress;
        $model->controller = $controller;
        $model->action = $action;
        $model->user_agent = $userAgent;
        $model->save();
        Log::whereDate( 'created_at', '<=', now()->subDays(90))->delete();
        return true;
    }
}

/**
 * 
 * @return user IP address
 * 
 */
if (! function_exists('getIPAaddress')) {
    function getIPAaddress(){
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';    
        return $ipaddress;
    }
    
}

/**
 * 
 * @return the country by id
 * 
 */

if (! function_exists('getCountryById')) {
    function getCountryById($id)
    {   
        $country = Country::where('id',$id)->first();
        return $country;
    }
}


/**
 * 
 * @return user details by id
 * 
 */

if (! function_exists('getUserById')){
    function getUserById($id){   
        $user = User::where('id',$id)->first();
        return $user;
    }
}


/**
 * 
 * @return sublabels of labels
 * 
 */

 if (! function_exists('getSublabelByLabelId')){
    function getSublabelByLabelId($id){   
        $user = User::where('parent_id',$id)->get();
        return $user;
    }
}


/**
 * 
 * @return DSP details using its id
 * 
 */
if (! function_exists('getDSPById')){
    function getDSPById($id){   
        $dsp = Dsp::where('id',$id)->first();
        return $dsp;
    }
}


/**
 * 
 * Price tires
 * 
 */


 if (! function_exists('release_prices_tires')){
    function release_prices_tires(){   
       return  $price_tiers = [
            'back'=>'Back',
            'budget_one'=>'Budget One',
            'budget_two'=>'Budget Two',
            'deluxe_one'=>'Deluxe One',
            'deluxe_two'=>'Deluxe Two',
            'deluxe_three'=>'Deluxe Three',
            'deluxe_four'=>'Deluxe Four',
            ];
    }
}



/**
 * 
 * Fetched all remixer from the
 * @App\Models\Track model
 * 
 */

 if (! function_exists('getTrackRemixers')){
    function getTrackRemixers(){ 
        $remixersObj = Track::select('remixer')->get();
        $remixerArr = [];
        foreach($remixersObj as $remixerStr){
            if(!empty($remixerStr->remixer)){
                $remixerArr = explode(',',$remixerStr->remixer);
                if(!empty($remixerArr)){
                    foreach($remixerArr as $remixer){
                        $remixerArr[] = $remixer;
                    }
                }
            }
        }
        return array_unique($remixerArr);
    }
}



/**
 * 
 * @return DSP details using its id
 * 
 */
if (! function_exists('getReleaseByTrackId')){
    function getReleaseByTrackId($id){   
        $release = Release::where('id',$id)->first();
        return $release;
    }
}


/**
 * 
 * @return track details using release id
 * 
 */
if (! function_exists('getTrackByReleaseId')){
    function getTrackByReleaseId($id){   
        $track = Track::where('release_id',$id)->first();
        return $track;
    }
}



/**
 * 
 * @return number of items on pagination * 
 * 
 */

if (! function_exists('itemsPerPage')){
    function itemsPerPage(){   
        return 50;
    }
}



/**
 * 
 * @return number of items on pagination * 
 * 
 */

 if (! function_exists('getGenreById')){
    function getGenreById($id){   
        $genreObj = Genre::where('id',$id)->first();
        return $genreObj; 
    }
}


/**
 * 
 * @return sub genre of genre * 
 * 
 */
 if (! function_exists('getSubGenreByGenreId')){
    function getSubGenreByGenreId($id){   
        $subGenreObj = SubGenre::where('genre_id',$id)->get();
        return $subGenreObj; 
    }
}



/**
 * 
 * @return name of artist by id
 * 
 */

 if (! function_exists('getArtistById')){
    function getArtistById($id){   
        $artistObj = Artist::where('id',$id)->first();
        return $artistObj; 
    }
}


/**
 * 
 * @return languages
 * 
 */

 if (! function_exists('getLangs')){
    function getLangs(){  
    return $codes = [
        'ab' => 'Abkhazian',
        'aa' => 'Afar',
        'af' => 'Afrikaans',
        'ak' => 'Akan',
        'sq' => 'Albanian',
        'am' => 'Amharic',
        'ar' => 'Arabic',
        'an' => 'Aragonese',
        'hy' => 'Armenian',
        'as' => 'Assamese',
        'av' => 'Avaric',
        'ae' => 'Avestan',
        'ay' => 'Aymara',
        'az' => 'Azerbaijani',
        'bm' => 'Bambara',
        'ba' => 'Bashkir',
        'eu' => 'Basque',
        'be' => 'Belarusian',
        'bn' => 'Bengali',
        'bh' => 'Bihari languages',
        'bi' => 'Bislama',
        'bs' => 'Bosnian',
        'br' => 'Breton',
        'bg' => 'Bulgarian',
        'my' => 'Burmese',
        'ca' => 'Catalan, Valencian',
        'km' => 'Central Khmer',
        'ch' => 'Chamorro',
        'ce' => 'Chechen',
        'ny' => 'Chichewa, Chewa, Nyanja',
        'zh' => 'Chinese',
        'cu' => 'Church Slavonic, Old Bulgarian, Old Church Slavonic',
        'cv' => 'Chuvash',
        'kw' => 'Cornish',
        'co' => 'Corsican',
        'cr' => 'Cree',
        'hr' => 'Croatian',
        'cs' => 'Czech',
        'da' => 'Danish',
        'dv' => 'Divehi, Dhivehi, Maldivian',
        'nl' => 'Dutch, Flemish',
        'dz' => 'Dzongkha',
        'en' => 'English',
        'eo' => 'Esperanto',
        'et' => 'Estonian',
        'ee' => 'Ewe',
        'fo' => 'Faroese',
        'fj' => 'Fijian',
        'fi' => 'Finnish',
        'fr' => 'French',
        'ff' => 'Fulah',
        'gd' => 'Gaelic, Scottish Gaelic',
        'gl' => 'Galician',
        'lg' => 'Ganda',
        'ka' => 'Georgian',
        'de' => 'German',
        'ki' => 'Gikuyu, Kikuyu',
        'el' => 'Greek (Modern)',
        'kl' => 'Greenlandic, Kalaallisut',
        'gn' => 'Guarani',
        'gu' => 'Gujarati',
        'ht' => 'Haitian, Haitian Creole',
        'ha' => 'Hausa',
        'he' => 'Hebrew',
        'hz' => 'Herero',
        'hi' => 'Hindi',
        'ho' => 'Hiri Motu',
        'hu' => 'Hungarian',
        'is' => 'Icelandic',
        'io' => 'Ido',
        'ig' => 'Igbo',
        'id' => 'Indonesian',
        'ia' => 'Interlingua (International Auxiliary Language Association)',
        'ie' => 'Interlingue',
        'iu' => 'Inuktitut',
        'ik' => 'Inupiaq',
        'ga' => 'Irish',
        'it' => 'Italian',
        'ja' => 'Japanese',
        'jv' => 'Javanese',
        'kn' => 'Kannada',
        'kr' => 'Kanuri',
        'ks' => 'Kashmiri',
        'kk' => 'Kazakh',
        'rw' => 'Kinyarwanda',
        'kv' => 'Komi',
        'kg' => 'Kongo',
        'ko' => 'Korean',
        'kj' => 'Kwanyama, Kuanyama',
        'ku' => 'Kurdish',
        'ky' => 'Kyrgyz',
        'lo' => 'Lao',
        'la' => 'Latin',
        'lv' => 'Latvian',
        'lb' => 'Letzeburgesch, Luxembourgish',
        'li' => 'Limburgish, Limburgan, Limburger',
        'ln' => 'Lingala',
        'lt' => 'Lithuanian',
        'lu' => 'Luba-Katanga',
        'mk' => 'Macedonian',
        'mg' => 'Malagasy',
        'ms' => 'Malay',
        'ml' => 'Malayalam',
        'mt' => 'Maltese',
        'gv' => 'Manx',
        'mi' => 'Maori',
        'mr' => 'Marathi',
        'mh' => 'Marshallese',
        'ro' => 'Moldovan, Moldavian, Romanian',
        'mn' => 'Mongolian',
        'na' => 'Nauru',
        'nv' => 'Navajo, Navaho',
        'nd' => 'Northern Ndebele',
        'ng' => 'Ndonga',
        'ne' => 'Nepali',
        'se' => 'Northern Sami',
        'no' => 'Norwegian',
        'nb' => 'Norwegian Bokmål',
        'nn' => 'Norwegian Nynorsk',
        'ii' => 'Nuosu, Sichuan Yi',
        'oc' => 'Occitan (post 1500)',
        'oj' => 'Ojibwa',
        'or' => 'Oriya',
        'om' => 'Oromo',
        'os' => 'Ossetian, Ossetic',
        'pi' => 'Pali',
        'pa' => 'Panjabi, Punjabi',
        'ps' => 'Pashto, Pushto',
        'fa' => 'Persian',
        'pl' => 'Polish',
        'pt' => 'Portuguese',
        'qu' => 'Quechua',
        'rm' => 'Romansh',
        'rn' => 'Rundi',
        'ru' => 'Russian',
        'sm' => 'Samoan',
        'sg' => 'Sango',
        'sa' => 'Sanskrit',
        'sc' => 'Sardinian',
        'sr' => 'Serbian',
        'sn' => 'Shona',
        'sd' => 'Sindhi',
        'si' => 'Sinhala, Sinhalese',
        'sk' => 'Slovak',
        'sl' => 'Slovenian',
        'so' => 'Somali',
        'st' => 'Sotho, Southern',
        'nr' => 'South Ndebele',
        'es' => 'Spanish, Castilian',
        'su' => 'Sundanese',
        'sw' => 'Swahili',
        'ss' => 'Swati',
        'sv' => 'Swedish',
        'tl' => 'Tagalog',
        'ty' => 'Tahitian',
        'tg' => 'Tajik',
        'ta' => 'Tamil',
        'tt' => 'Tatar',
        'te' => 'Telugu',
        'th' => 'Thai',
        'bo' => 'Tibetan',
        'ti' => 'Tigrinya',
        'to' => 'Tonga (Tonga Islands)',
        'ts' => 'Tsonga',
        'tn' => 'Tswana',
        'tr' => 'Turkish',
        'tk' => 'Turkmen',
        'tw' => 'Twi',
        'ug' => 'Uighur, Uyghur',
        'uk' => 'Ukrainian',
        'ur' => 'Urdu',
        'uz' => 'Uzbek',
        've' => 'Venda',
        'vi' => 'Vietnamese',
        'vo' => 'Volap_k',
        'wa' => 'Walloon',
        'cy' => 'Welsh',
        'fy' => 'Western Frisian',
        'wo' => 'Wolof',
        'xh' => 'Xhosa',
        'yi' => 'Yiddish',
        'yo' => 'Yoruba',
        'za' => 'Zhuang, Chuang',
        'zu' => 'Zulu'
    ];
    }
}


