<?php $__env->startSection('content'); ?>

<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Add Sub Genre</h6>
        </div>

        <div class="releases-sec-main">

            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <form class="add-releses-form" method="POST" action="<?php echo e(route('subgenre.store')); ?>" id="frmAddSubGenre">
            <?php echo csrf_field(); ?>

                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                    <div class="form-group">
                    <label class="form-label required" for="genre">Genre 
                                    <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the genre."></i>
                                </label>
                        <select name="genre_id" id="genre_id" class="form-control">
                            <option value="">Select Genre</option>

                            <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($genre->id); ?>"><?php echo e($genre->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </select>
                    </div>
                </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Sub Genre Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the sub genre."></i>
                            </label>
                            <input type="text" class="form-control" placeholder="Sub Genre Name" id="title" name="title" value="<?php echo e(old('title')); ?>" />
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label" for="description">Sub Genre Descriptions</label>
                            <textarea class="form-control" id="description" name="description"><?php echo e(old('description')); ?></textarea>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label required" for="status">Sub Genre Status
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select whether the sub genre is active or disabled."></i>
                            </label>
                            <select name="status" id="status" class="form-control">
                                <option <?php if(old('status')==1): ?> selected <?php endif; ?> value="1">Active</option>
                                <option <?php if(old('status')==0): ?> selected <?php endif; ?> value="0">Disabled</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddSubGenre").validate({
            rules: {
                genre_id: {
                    required: true
                },
                title: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                genre_id: {
                    required: "Genre field is required"
                },
                title: {
                    required: "Sub Genre Name field is required"
                },
                status: {
                    required: "Sub Genre Status field is required"
                },
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>






















<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/subgenres/create.blade.php ENDPATH**/ ?>