<?php $__env->startSection('content'); ?>





<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View DSP</h6>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['create-dsp'])): ?>
            <div class="view-all-release-search">
                <a href="<?php echo e(route('dsp.create')); ?>"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            <?php endif; ?>


        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>DSP Name</th>
                        <th>DSP Status</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dsp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(++$i); ?></td>
                        <td><?php echo e($dsp->name); ?></td>

                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-dsp'])): ?>
                            <input type="checkbox" id="dsp_<?php echo e($dsp->id); ?>" class="form-check-input dspStatus" name="dspStatus" <?php if($dsp->status==1): ?> checked <?php endif; ?> />
                            <?php endif; ?>

                            <?php if(!empty($dsp->status)): ?>
                            <label id="dspStatus_<?php echo e($dsp->id); ?>" class="badge bg-success">Active</label>
                            <?php else: ?>
                            <label id="dspStatus_<?php echo e($dsp->id); ?>" class="badge bg-danger">Disabled</label>
                            <?php endif; ?>
                        </td>

                        <td>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['edit-dsp'])): ?>
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('dsp.edit',$dsp->id)); ?>"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['delete-dsp'])): ?>
                            <form method="POST" action="<?php echo e(route('dsp.destroy', $dsp->id)); ?>" style="display:inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                            <?php endif; ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
            </table>
            <?php echo $data->links('pagination::bootstrap-5'); ?>


        </div>
    </div>
</section>



<script>
    $(document).ready(function() {
        $(".dspStatus").change(function() {

            var dspStr = $(this).attr('id');
            var dspArr = dspStr.split("_");
            var dspId = dspArr[1];

            $.ajax({
                url: "<?php echo e(route('dsp.status.update')); ?>",
                type: "POST",
                data: {
                    dspId: dspId,
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(requestResponse) {

                    var dspStatusId = "dspStatus_" + dspId;

                    if (requestResponse == "disabledDSP") {
                        $(this).prop('checked', false);
                        $("#" + dspStatusId).removeClass("bg-success");
                        $("#" + dspStatusId).addClass("bg-danger");
                        $("#" + dspStatusId).text("Disabled");
                    } else if (requestResponse == "activeDSP") {
                        $(this).prop('checked', true);
                        $("#" + dspStatusId).addClass("bg-success");
                        $("#" + dspStatusId).removeClass("bg-danger");
                        $("#" + dspStatusId).text("Active");
                    }
                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });


    });
</script>







<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/dsps/index.blade.php ENDPATH**/ ?>