<?php $__env->startSection('content'); ?>

<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Genre</h6>
        </div>

        <div class="releases-sec-main">

            <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <form method="POST" class="add-releses-form" id="frmAddGenre" action="<?php echo e(route('genre.update', $genre->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="genre">Genre Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the genre."></i>
                            </label>
                            <input type="text" class="form-control" placeholder="Genre Name" id="title" name="title" value="<?php echo e($genre->title); ?>" />
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label" for="description">Genre Descriptions</label>
                            <textarea class="form-control" id="description" name="description"><?php echo e($genre->description); ?></textarea>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label required" for="status">Genre Status
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select whether the genre is active or disabled."></i>
                            </label>
                            <select name="status" id="status" class="form-control">
                            <option <?php if($genre->status==1): ?> selected <?php endif; ?> value="1">Active</option>
                            <option <?php if($genre->status==0): ?> selected <?php endif; ?> value="0">Disabled</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Update</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddGenre").validate({
            rules: {
                title: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                title: {
                    required: "Genre Name field is required"
                },
                status: {
                    required: "Genre Status field is required"
                },
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>







<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/genres/edit.blade.php ENDPATH**/ ?>