<form class="add-releses-form" method="POST" action="<?php echo e(route('release.store')); ?>" id="frmReleaseStepAlbum1" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" class="form-control" name="release_type" value="album">

    <div class="chose-file-sec">
        <div class="chose-mainbox albumartworkpreviewimage" id="release_album_art_work">
            <div class="file-icon">
                <i class="fa-solid fa-plus"></i>
            </div>
            <div class="chose-file-content" id="album_chose-file-content_artwork">
                <h5 class="required">Choose file for Art Work</h5>
            </div>
            <input type="file" name="artwork" id="album_artwork_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
            <p id="album_error-message" style="color:#dc3545"></p>
        </div>

        <div class="chose-mainbox albumappleartworkpreviewimage" id="release_album_apple_art_work">
            <div class="file-icon">
                <i class="fa-solid fa-plus"></i>
            </div>
            <div class="chose-file-content" id="album_apple_chose-file-content_artwork">
                <h5>Choose file for Apple (Motion Art)</h5>
            </div>
            <input type="file" name="apple_art" id="album_apple_art_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
        </div>


        <div class="chose-mainbox" data-bs-toggle="modal" data-bs-target="#addAlbumLyrics">
            <div class="file-icon">
                <i class="fa-solid fa-plus"></i>
            </div>
            <div class="chose-file-content">
                <h5>Add Lyrics</h5>
            </div>

            
        </div>

        <div class="modal fade add-lyricist-modal" id="addAlbumLyrics" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Lyricist</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                    </div>

                    <div class="modal-body">
                        <div class="Upload-mainbox" id="releaseuploadlyrics">
                            <div class="file-icon">
                                <i class="fa-solid fa-plus"></i>
                            </div>
                            <h5>Upload Lyrics</h5>
                        </div>
                        <p>Or</p>

                        <input type="file" name="singleReleaseLyricFile" id="albumReleaseLyricFile" class="form-control" style="display:none;" accept=".txt" />
                        <div class="form-group">
                            <label class="form-label" for="uploadLyrics">Paste</label>
                            <input class="form-control" type="text" id="lyric_urls" name="lyric_urls" />
                        </div>
                        <div class="form-group-button">
                            <button type="button" class="btn lyricsBtn" id="albumReleaselyricsSubmit">Upload</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="releases-sec-main">
        <!-- <form class="add-releses-form"> -->
        <div class="row">
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="language">Language<i class="fa-solid fa-circle-info"></i></label>
                    <select name="lang" id="language" class="form-control" required>
                        <option value="">Select Language</option>
                        <?php $__currentLoopData = getLangs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langCode => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($langCode); ?>" <?php if($langCode=='en' ): ?> selected <?php endif; ?>><?php echo e(ucfirst($langName)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="Release-Title">Release Title<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" name="title" id="Release-Title" required value="<?php echo e(old('title')); ?>">
                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="primary-artist">Choose Primary Artist<i class="fa-solid fa-circle-info"></i></label>
                    <div class="artist-sec">
                        <select name="artists" id="artists" class="form-control" required>
                            <option value="">Select Artist</option>
                            <?php $__currentLoopData = $artists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $artist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($artist->id); ?>" <?php if(old('artists')==$artist->id): ?> selected <?php endif; ?>><?php echo e(ucfirst($artist->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>


                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['create-artists'])): ?>
                        <a href="javascript:void(0);" id="addAlbumArtistRelease">
                            <button type="button" class="btn artist-sec-btn"><i class="fa-solid fa-plus"></i>Add Artist</button>
                        </a>
                        
                        <?php endif; ?>


                    </div>


                    <!-- Add artist modals -->

                    


                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="display-artist">Display Artist<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" name="display_artist" id="display-artist" value="<?php echo e(old('display_artist')); ?>" />
                </div>
            </div>

            <?php
            $user = Auth::user();
            $userRoles = null;
            if ($user && $user->roles->isNotEmpty()) {
            $role = $user->roles->first();
            $userRoles = $role->name;
            }
            ?>

            <?php if(!empty($userRoles) && $userRoles!="Super Admin"): ?>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="label">Label<i class="fa-solid fa-circle-info"></i></label>
                    <select name="label_id" id="label_id" class="form-control">
                        <option value="">Select Label</option>
                        <?php $__currentLoopData = $lablesUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($user->id); ?>" <?php if(old('label_id')==$user->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($user->name)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <?php endif; ?>


            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="label">Do you have UPC?<i class="fa-solid fa-circle-info"></i></label>
                    <div class="main-form-radio d-flex justify-content-start gap-3">

                        <div class="radio-btn">
                            <input type="radio" value="1" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_yes">
                            <label class="form-check-label" for="yes">Yes</label>
                        </div>

                        <div class="radio-btn">
                            <input checked type="radio" value="0" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_no">
                            <label class="form-check-label" for="no">No</label>
                        </div>

                    </div>
                </div>
            </div>


            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" id="upc_label_req_album" for="upc">UPC/EAN<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" placeholder="upc/ean" id="single_upc_number_album" name="upc_number" readonly disabled />
                </div>
            </div>

            

            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="cline">C-Line<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" name="c_line" class="form-control" placeholder="C-Line" id="cline" value="<?php echo e($selectedLabels ?? ''); ?>" required />
                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="cLineYear">C-Line Year<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" name="c_line_year" class="form-control" placeholder="C-Line Year" id="c_line_year" value="<?php echo e(old('c_line_year') ?? date('Y')); ?>" required />
                </div>
            </div>

            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="pline">P-Line<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" name="p_line" class="form-control" placeholder="P-Line" id="pline" required value="<?php echo e($selectedLabels ?? ''); ?>" />
                </div>
            </div>

            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="pLineYear">P-Line Year<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" name="p_line_year" class="form-control" placeholder="P-Line Year" id="pLineYear" value="<?php echo e(old('p_line') ?? date('Y')); ?>" required />
                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="release_date">Release Date<i class="fa-solid fa-circle-info"></i></label>
                    <input type="date" class="form-control" placeholder="Release Date" id="release_date" name="release_date" required value="<?php echo e(old('release_date')); ?>" />
                </div>
            </div>
            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="main_genre">Main Genre<i class="fa-solid fa-circle-info"></i></label>
                    <select name="genre_id" id="albumgenre_id" class="form-control" required>
                        <option value="">Select Genre</option>
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($genre->id); ?>" <?php if(old('genre_id')==$genre->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($genre->title)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                </div>
            </div>

            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="albumsubgenredata">
                <div class="form-group main-form">
                    <label class="form-label required" for="sub_genre">Sub Genre<i class="fa-solid fa-circle-info"></i></label>
                    <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                        <option value="">Select Sub Genre</option>
                    </select>

                </div>
            </div>

            <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">

                

                <div class="form-group main-form">
                <label class="form-label required" for="lyricist">Composer
                    <i class="fa-solid fa-circle-info"></i></label>

                <div class="sub-sec">
                    <input type="text" class="form-control" placeholder="First Name" id="Composer" name="composer" required value="<?php echo e(old('composer')); ?>" />

                    <input type="text" name="composer_lastname" class="form-control" placeholder="Last Name" id="composer_lastname" value="<?php echo e(old('composer_lastname')); ?>" required />
                </div>
            </div>

            </div>


            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label required" for="lyricist">Lyricist<i class="fa-solid fa-circle-info"></i></label>
                    <div class="sub-sec">
                        <input type="text" name="lyricist_firstname" class="form-control" placeholder="First" id="lyricist_firstname" value="<?php echo e(old('lyricist_firstname')); ?>" required />

                        <input type="text" name="lyricist_lastname" class="form-control" placeholder="Last" id="lyricist_lastname" value="<?php echo e(old('lyricist_lastname')); ?>" required />
                    </div>
                </div>
            </div>


            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="catalogue_no">Catalogue Number<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" name="cat_number" class="form-control" placeholder="Catalogue Number" id="cat_number" value="<?php echo e(old('cat_number')); ?>" />

                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="fe_artist">Featured Artist<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="<?php echo e(old('feature_artist')); ?>" />
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="fe_artist">Is Instrumental?<i class="fa-solid fa-circle-info"></i></label>

                    <div class="main-form-radio d-flex justify-content-start gap-3">

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_yes" value="1" <?php if(old('is_instrumental')==1): ?> selected <?php endif; ?> />
                            <label class="form-check-label" for="is_yes">Yes</label>
                        </div>

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_no" checked value="0" <?php if(old('is_instrumental')==0): ?> selected <?php endif; ?> />
                            <label class="form-check-label" for="is_no">No</label>
                        </div>


                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="actor">Actor<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" placeholder="Actor" id="actor" name="actor" value="<?php echo e(old('actor')); ?>">
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="conductor">Conductor<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" placeholder="Conductor" id="conductor" name="conductor" value="<?php echo e(old('conductor')); ?>">
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="remixer">Remixer<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" placeholder="Remixer" id="remixer" name="remixer" value="<?php echo e(old('remixer')); ?>" />
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">
                    <label class="form-label" for="arranger">Arranger<i class="fa-solid fa-circle-info"></i></label>
                    <input type="text" class="form-control" placeholder="Arranger" id="arranger" name="arranger" value="<?php echo e(old('arranger')); ?>" />
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                <div class="form-group main-form">


                    <label class="form-label sub-label" for="start">CRBT (Start Time)</label>
                    <input class="form-control" type="time" class="form-control" placeholder="08:30" id="crbt_start_time" name="crbt_start_time" value="<?php echo e(old('crbt_start_time')); ?>" />


                    


            </div>
        </div>

        


    <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
        <div class="form-group main-form">
            <label class="form-label" for="copyright_fe">Copyright<i class="fa-solid fa-circle-info"></i></label>
            <input type="text" class="form-control" placeholder="Copyright" id="copyright_fe" name="copyrights" value="<?php echo e(old('copyrights')); ?>" />
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
        <div class="form-group main-form">
            <label class="form-label" for="orchestra">Orchestra<i class="fa-solid fa-circle-info"></i></label>
            <input type="text" class="form-control" placeholder="Orchestra" id="orchestra" name="orchestra" value="<?php echo e(old('orchestra')); ?>" />
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
        <div class="form-group main-form">
            <label class="form-label" for="parental_warn">Parental Warning Type<i class="fa-solid fa-circle-info"></i></label>

            <!-- <input type="text" class="form-control" placeholder="Explicit" id="parental_warn" > -->

            <select name="parental_warning_type" id="parental_warning_type" class="form-control">
                <option value="NotExplicit" <?php if(old('parental_warning_type')=="NotExplicit" ): ?> selected <?php endif; ?>>NotExplicit</option>
                <option value="Explicit" <?php if(old('parental_warning_type')=="Explicit" ): ?> selected <?php endif; ?>>Explicit</option>
                <option value="ExplicitContentEdited" <?php if(old('parental_warning_type')=="ExplicitContentEdited" ): ?> selected <?php endif; ?>>ExplicitContentEdited</option>
            </select>
        </div>
    </div>
    <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
        <div class="form-group main-form">
            <label class="form-label" for="price_tiers">Price Tiers (For iTunes Only)<i class="fa-solid fa-circle-info"></i></label>
            <!-- <input type="text" class="form-control" placeholder="Budget Two" id="price_tiers"> -->

            <select name="price_tier" id="price_tier" class="form-control">
                <option value="">Select Price Tier</option>

                <?php $__currentLoopData = release_prices_tires(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price_key => $price_val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($price_key); ?>" <?php if(old('price_tier')==$price_key): ?> selected <?php endif; ?>>
                    <?php echo e($price_val); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </select>


        </div>
    </div>
    <div class="col-md-12 col-lg-12 col-xl-12">
        <div class="form-group main-form">
            <label class="form-label" for="release_desc">Release Descriptions</label>

            <!-- <textarea class="form-control" id="release_desc" placeholder="Type Here"></textarea> -->

            <textarea style="height: 131px;" name="description" id="description" class="form-control"><?php echo e(old('description')); ?></textarea>

        </div>
    </div>
    <div class="col-md-12 col-lg-12 col-xl-12">
        <div class="form-group main-form d-flex gap-2">
            <button type="submit" class="btn main-next-btn">Next</button>
            
        </div>
    </div>



    </div>
    <!-- </form> -->
    </div>
</form>

<script type="text/javascript">
    $(document).ready(function() {

        let isAlbumAppleClickTriggered = false;
        $('#release_album_apple_art_work').click(function() {
            if (!isAlbumAppleClickTriggered) {
                isAlbumAppleClickTriggered = true;
                $('#album_apple_art_file').trigger('click');
                isAlbumAppleClickTriggered = false;
            }
        });


        let isAlbumArtWorkClickTriggered = false;
        $('#release_album_art_work').click(function() {
            if (!isAlbumArtWorkClickTriggered) {
                isAlbumArtWorkClickTriggered = true;
                $('#album_artwork_file').trigger('click');
                isAlbumArtWorkClickTriggered = false;
            }
        });


        $('#album_artwork_file').on('change', function (e) {
        var file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            var reader = new FileReader();
            reader.onload = function (event) { 
                $('.albumartworkpreviewimage').css({
                'background-image': 'url("'+event.target.result+'")'
                });
                $('#album_chose-file-content_artwork').hide();
                $('#album_error-message').hide();
            }
            reader.readAsDataURL(file);
        } else {
            alert('Please select a valid image file');
            return false;
        }       
    });

    $('#album_apple_art_file').on('change', function (e) {
        var file = e.target.files[0];
        if (file && file.type.startsWith('image/')) {
            var reader = new FileReader();
            reader.onload = function (event) { 
                $('.albumappleartworkpreviewimage').css({
                'background-image': 'url("'+event.target.result+'")'
                });
                $('#album_apple_chose-file-content_artwork').hide();
            }
            reader.readAsDataURL(file);
        } else {
            alert('Please select a valid image file');
            return false;
        }       
    });



    $('#frmReleaseStepAlbum1').submit(function(e) {
            // Get the file input element
            var fileInput = $('#album_artwork_file')[0];
            var file = fileInput.files[0];

            // Clear previous error messages
            $('#album_error-message').hide();
            // Check if a file was selected
            if (!file) {
                $('#album_error-message').text('Art Work field is required').show();
                e.preventDefault(); // Prevent form submission
                return false;
            }

            // Validate file type (only WAV files)
            // var fileType = file.type;
            // if (fileType !== 'audio/wav') {
            //     $('#error-message').text('Only WAV files are allowed.').show();
            //     e.preventDefault(); // Prevent form submission
            //     return;
            // }

            // Validate file size (max 10MB)
            // var fileSize = file.size;
            // var maxSize = 10 * 1024 * 1024; // 10MB in bytes
            // if (fileSize > maxSize) {
            //     $('#error-message').text('File size must be less than 10MB.').show();
            //     e.preventDefault(); // Prevent form submission
            //     return;
            // }

        });






        $(document).on('click', '#albumReleaselyricsSubmit', function() {
            var file = $('#albumReleaseLyricFile')[0].files[0]; // Get the file
            var formData = new FormData(); // Create FormData object
            formData.append('file', file); // Append the file to FormData
            formData.append('_token', "<?php echo e(csrf_token()); ?>"); // Append CSRF token to FormData

            $.ajax({
                url: "<?php echo e(route('upload.release.single.lyrics')); ?>",
                type: 'POST',
                data: formData, // Send FormData
                contentType: false, // Don't set content type because FormData sets it automatically
                processData: false, // Don't process data because it's a file upload
                xhr: function() {
                    var xhr = new XMLHttpRequest();
                    xhr.upload.addEventListener('progress', function(e) {
                        if (e.lengthComputable) {
                            $("#addAlbumLyrics").hide();
                            $('#addAlbumLyrics').modal('hide');
                            var percent = (e.loaded / e.total) * 100;
                            $('#albumprogressBar').css('width', percent + '%');
                            $('#albumprogressBar').text(Math.round(percent) + '%');
                        }
                    }, false);

                    return xhr;
                },
                success: function(response) {
                    // alert('File uploaded successfully!');
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while uploading the file');
                }
            });
        });

        $("#addAlbumArtistRelease").click(function() {
            $.ajax({
                url: "<?php echo e(route('release.artist.create')); ?>",
                type: "POST",
                data: {
                    'flag': 'release',
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(html) {
                    window.location.href = "<?php echo e(route('artists.create')); ?>";
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("#albumgenre_id").change(function() {
            var genre_id = $(this).val();
            $.ajax({
                url: "<?php echo e(route('release.subgenre')); ?>",
                type: "POST",
                data: {
                    'genre_id': genre_id,
                    "_token": "<?php echo e(csrf_token()); ?>"
                },
                cache: false,
                success: function(html) {
                    html = html.replace("<strong>", "<label>");
                    html = html.replace("</strong>", "</label>");
                    $("#albumsubgenredata").html(html);
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("input:radio.albumReleaseUPC").click(function() {
            if ($('input:radio.albumReleaseUPC:checked').val() == "1") {
                $('#single_upc_number_album').prop('disabled', false);
                $('#single_upc_number_album').removeAttr('readonly');
                $('#single_upc_number_album').attr('required', true);
                $('#upc_label_req_album').addClass('required');
            }

            if ($('input:radio.albumReleaseUPC:checked').val() == "0") {
                $('#single_upc_number_album').val('');
                $('#single_upc_number_album').prop('disabled', true);
                $('#single_upc_number_album').attr('readonly', true);
                $('#single_upc_number_album').removeAttr('required', true);
                $('#upc_label_req_album').removeClass('required');
            }

        });




    });
</script><?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/releases/create-album.blade.php ENDPATH**/ ?>