@extends('layouts.app')

@section('content')






<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit User's DSP</h6>
        </div>

        <div class="releases-sec-main">

            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="add-releses-form" method="POST" action="{{ route('userdsp.update', $userdsp->id) }}" id="frmAddUserDSP">
                @csrf


                @method('PUT')



                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">User
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the User."></i>
                            </label>
                            <select name="user_id" id="user_id" class="form-control">

                                <option value="">Select User</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}" @if($userdsp->user_id == $user->id) selected @endif >{{ $user->name }}</option>
                                @endforeach


                            </select>
                        </div>
                    </div>



                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">DSP
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the DSP."></i>
                            </label>
                            <select name="dsp_id" id="dsp_id" class="form-control">
                                <option value="">Select DSP</option>
                                @foreach($dsps as $dsp)
                                <option value="{{ $dsp->id }}" @if($userdsp->dsp_id == $dsp->id) selected @endif >{{ $dsp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    @php
                    $savedCountries = [];
                    if(!empty(json_decode($userdsp->country_ids))){
                    $savedCountries = json_decode($userdsp->country_ids);
                    }
                    @endphp

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group">
                            <label class="form-label required" for="genre">Countries
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select name of the countries."></i>
                            </label>
                            <select name="country_ids[]" id="country_ids" class="form-control" multiple>
                                @foreach($countries as $country)
                                <option value="{{ $country->id }}" @if(in_array($country->id, $savedCountries)) selected @endif >{{ $country->name }}</option>
                                @endforeach             
                            </select>
                        </div>
                    </div>


                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddUserDSP").validate({
            rules: {
                user_id: {
                    required: true
                },
                dsp_id: {
                    required: true
                },
                "country_ids[]": {
                    required: true
                },
            },
            messages: {
                user_id: {
                    required: "User field is required"
                },
                dsp_id: {
                    required: "DSP Name field is required"
                },
                "country_ids[]": {
                    required: "Countries field is required"
                },
            }
        });
    });
</script>

















{{--<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Edit User`s DSP</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('userdsp.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
</div>
</div>
</div>

@if (count($errors) > 0)
<div class="alert alert-danger">
    <strong>Whoops!</strong> There were some problems with your input.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form method="POST" action="{{ route('userdsp.update', $userdsp->id) }}" id="frmUserDSPCreated">
    @csrf
    @method('PUT')

    <div class="row">



        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>User:</strong>
                <select name="user_id" id="user_id" class="form-control">
                    <option value="">Select User</option>
                    @foreach($users as $user)
                    <option value="{{ $user->id }}" @if($userdsp->user_id == $user->id) selected @endif >{{ $user->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>DSP:</strong>
                <select name="dsp_id" id="dsp_id" class="form-control">
                    <option value="">Select DSP</option>
                    @foreach($dsps as $dsp)
                    <option value="{{ $dsp->id }}" @if($userdsp->dsp_id == $dsp->id) selected @endif >{{ $dsp->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        @php
        $savedCountries = [];
        if(!empty(json_decode($userdsp->country_ids))){
        $savedCountries = json_decode($userdsp->country_ids);
        }
        @endphp

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Countries:</strong>
                <select name="country_ids[]" id="country_ids" class="form-control" multiple>
                    @foreach($countries as $country)
                    <option value="{{ $country->id }}" @if(in_array($country->id, $savedCountries)) selected @endif >{{ $country->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Submit</button>
        </div>
    </div>
</form>


<script>
    $(document).ready(function() {
        $("#frmUserDSPCreated").submit(function(e) {

            var userId = $('#user_id').val();
            var dspId = $('#dsp_id').val();

            $.ajax({
                url: "{{route('userdsp.userDspStatus')}}",
                type: "POST",
                data: {
                    'userId': userId,
                    'dspId': dspId,
                    "userdsp_id": "{{ $userdsp->user_id }}",
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    if (requestResponse == "alreadyExist") {
                        alert('DSP is already exist with this user!');
                        return false;
                    }
                },
                error: function(response) {
                    alert('Something went wrong!');
                    return false;
                }

            });
        });
    });
</script>--}}

@endsection