@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>UPC Management</h2>
        </div>

        <div class="pull-right d-flex justify-content-between align-center">

        @can('upcs.create')
        <div>
            <a class="btn btn-success mb-2" href="{{ route('upcs.create') }}"><i class="fa fa-plus"></i> Create New UPC</a>
            <a class="btn btn-success mb-2" data-bs-toggle="modal" data-bs-target="#staticBackdrop" href="javascript:void(0);"><i class="fa fa-plus"></i> Upload New UPC</a>
        </div>
        @endcan

        <div class="d-flex justify-content-between align-center gap-3">
        <p class="small">Total UPC: {{ $totalRecords }}</p>
          <p class="small text-success">New UPC: {{ $newRecords }}</p>
          <p class="small text-danger">Used UPC: {{ $oldRecords }}</p>
      </div>

        </div>


      
    </div>
</div>

@session('success')
    <div class="alert alert-success" role="alert"> 
        {{ $value }}
    </div>
@endsession


@if (count($errors) > 0)
    <div class="alert alert-danger">
      <strong>Whoops!</strong> There were some problems with your input.<br><br>
      <ul>
         @foreach ($errors->all() as $error)
           <li>{{ $error }}</li>
         @endforeach
      </ul>
    </div>
@endif

<table class="table table-bordered">
   <tr>
       <th>No</th>
       <th>Upc</th>
       <th>Ean</th>
       <th>Status</th>   
       <th width="280px">Action</th>
   </tr>
   @foreach ($data as $key => $upc)
    <tr>
        <td>{{ ++$i }}</td>
        <td>{{ $upc->upc }}</td>
        <td>{{ $upc->ean }}</td>
        <td>
          @if(!empty($upc->status))
               <label class="badge bg-danger">Used</label>
               @else
               <label class="badge bg-success">New</label>

          @endif
        </td>
        <td>
          
          {{--@can('upcs.edit')--}}
             <a class="btn btn-primary btn-sm" href="{{ route('upcs.edit',$upc->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
          {{--@endcan--}}

          {{-- @can('upcs.destroy')--}}
              <form method="POST" action="{{ route('upcs.destroy', $upc->id) }}" style="display:inline">
                  @csrf
                  @method('DELETE')
                  <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
              </form>
              {{--@endcan--}}
        </td>
    </tr>
 @endforeach
</table>

{!! $data->links('pagination::bootstrap-5') !!}


<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Upload File</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <form name="upload_file" action="{{ route('upcs.manual.upload') }}" method="post" enctype="multipart/form-data">
      @csrf
      <div class="modal-body">

      <div class="row">

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Choose CSV File:</strong>
                <input type="file" name="upload_file" class="form-control"  accept=".csv">
            </div>
        </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>
    </form>

    </div>
  </div>
</div>

@endsection
