@extends('layouts.app')

@section('content')

<section class="right-sidebar" id="sidebarRight">
        <div class="view-release-sec">
            <div class="view-release">
                <div class="view-release-heading">
                    <h6>View Releases</h6>
                </div>
                <div class="view-all-release-search">
                    <form >
                        <div class="form-group">
                            <input type="text" class="form-control" id="view_release-search" placeholder="Search by releases">
                            <div class="view-search-icon">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </div>
                        </div>
                    </form>
                    <button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Advancesd</button>
                </div>
            </div>

            <div class="viewReleases-main-sec">
                <table class="table table-bordered">
                    <thead>
                      <tr>
                        <th>SR. No</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Title / Artist</th>
                        <th>Label</th>
                        <th>Release Date/Hour/Time/Zone </th>
                        <th># Of track</th>
                        <th>UPC / Catalogue Number</th>
                        <th>Promotion</th>
                        <th>Delievered Territories & Store</th>
                        <th></th>
                       </tr>
                    </thead>
                    <tbody>

                    @foreach ($data as $key => $release)
                    @php 
                        $lablename = '';
                        if(!empty($release->label_id))
                        {
                            $labelUserId =  $release->label_id;
                            $user = App\Models\User::where('id',$labelUserId)->first();
                            if(!empty($user)){
                                $lablename = $user->name;
                            }

                        }
                        $totalTracks = App\Models\Track::where('release_id', $release->id)->count();

                    @endphp 

                    <tr>
                        <td>{{ ++$i }}</td>
                        <td> 
                            @if($release->release_type=="release")

                            Single 

                            @elseif($release->release_type=="album")

                            Album

                            @endif
                        </td>
                        <td>

                        @if($release->status==0)
                            <div class="status-ok">
                                <img src="{{asset('assets/img/status.png') }}" alt="{{ $release->title }}">
                            </div>
                        @elseif($release->status==1) 
                        <div class="status-ok">
                                <img src="{{asset('assets/img/statusOK.png') }}" alt="{{ $release->title }}">
                        </div>
                        @endif

                        </td>
                        <td><a style="color:#35bdaa;"href="{{ route('release.show',$release->id) }}">{{ $release->title }}</a></td>
                        
                        <td>{{ $lablename }}</td>
                        <td>{{ $release->release_date }}</td>
                        <td>{{ $totalTracks }}</td>
                        <td>
                            @if(!empty($release->cat_number))
                            {{ $release->cat_number }}
                            @else 
                            {{ $release->upc_number }}
                            @endif
                        </td>
                        <td></td>
                        <td></td>

                        <td class="download-content-btn"> 
                            <button class="btn download-meta">Download Meta</button>
                            <button class="btn download-audio">Download Audio</button>



                        </td>

                        {{--
                            <td>{{ $release->artists }}</td>
                        <td>{{ $release->remixer }}</td>
                        <td>{{ $release->label_id }}</td>
                        <td>{{ $release->exclusive_on_shop }}</td>
                        <td>{{ $release->cat_number }}</td>
                        <td>{{ $release->upc_number }}</td>
                        <td>{{ $release->release_date }}</td>
                        <td>{{ $release->published_date }}</td>
                        <td>{{ $totalTracks }}</td>
                       
                        <td>
                            <a class="btn btn-primary btn-sm" href="{{ route('release.edit',$release->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            <form method="POST" action="{{ route('release.destroy', $release->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                        </td>
                         --}}
                    </tr>
                @endforeach
                    </tbody>
                </table>
                {!! $data->links('pagination::bootstrap-5') !!}
            </div>
        </div>
    </section>

    
{{--
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Release Management</h2>
        </div>

        <div class="pull-right">
            <a class="btn btn-success mb-2" href="{{ route('release.create') }}"><i class="fa fa-plus"></i> Create New Release</a>
        </div>

    </div>
</div>

    @session('success')
        <div class="alert alert-success" role="alert"> 
            {{ $value }}
        </div>
    @endsession

<table class="table table-bordered">
   <tr>
       <th>No</th>
       <th>ArtWork</th>
       <th>Release Name</th>
       <th>Artist</th>
       <th>Remixers</th>
       <th>Label</th>
       <th>Exclusive</th>
       <th>Catalog Number</th>
       <th>UPC/EAN</th>
       <th>Release Date</th>
       <th>Published Date</th>
       <th>Track Count</th>
       <th width="280px">Action</th>
   </tr>
   @foreach ($data as $key => $release)
    <tr>
        <td>{{ ++$i }}</td>
        <td><i class="fa fa-cloud-download"></i></td>
        <td>{{ $release->title }}</td>
        <td>{{ $release->artists }}</td>
        <td>{{ $release->remixer }}</td>
        <td>{{ $release->label_id }}</td>
        <td>{{ $release->exclusive_on_shop }}</td>
        <td>{{ $release->cat_number }}</td>
        <td>{{ $release->upc_number }}</td>
        <td>{{ $release->release_date }}</td>
        <td>{{ $release->published_date }}</td>
        <td>track count</td>

        <td>
             <a class="btn btn-primary btn-sm" href="{{ route('release.edit',$release->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
              <form method="POST" action="{{ route('release.destroy', $release->id) }}" style="display:inline">
                  @csrf
                  @method('DELETE')
                  <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
              </form>
        </td>
    </tr>
 @endforeach
</table>

{!! $data->links('pagination::bootstrap-5') !!}

<script>
$(document).ready(function(){
  $(".dspStatus").change(function(){
    
        var dspStr = $(this).attr('id');
        var dspArr = dspStr.split("_");
        var dspId = dspArr[1];
       
        $.ajax({
        url: "{{route('dsp.status.update')}}",
        type: "POST",
        data: {dspId : dspId,"_token": "{{ csrf_token() }}" },
        cache: false,
        success: function(requestResponse){

            var dspStatusId = "dspStatus_"+dspId;

            if(requestResponse=="disabledDSP"){
                $(this).prop('checked', false); 
                $("#"+dspStatusId).removeClass("bg-success");
                $("#"+dspStatusId).addClass("bg-danger");
                $("#"+dspStatusId).text("Disabled");
            }
            
            else if(requestResponse=="activeDSP"){
                $(this).prop('checked', true); 
                $("#"+dspStatusId).addClass("bg-success");
                $("#"+dspStatusId).removeClass("bg-danger");
                $("#"+dspStatusId).text("Active");
            }
        },

        error: function(response){
            alert('Something went wrong!');
            console.log(response);
            return false;
        }

        });

  });
});
</script>

--}}

@endsection
