
<form class="form-addSingle" method="post" action="{{ route('release.track.edit.modal',$release->id) }}" enctype="multipart/form-data">
    @csrf
    <input type="hidden" name="track_id" value="{{ $track->id }}" />
    <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="artistSingle">Artist</label>

                    <select name="artists" id="artists" class="form-control" required>
                        <option value="">Select Artist</option>
                        @foreach($artists as $artist)
                        <option value="{{ $artist->id }}"
                            @if($artist->id==$track->artists) selected @endif>{{ ucfirst($artist->name) }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="displayArtist">Display Artist</label>
                    <input type="text" class="form-control" name="display_artist" id="display-artist" value="{{ $track->display_artist ?? '' }}" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="featuredArtist">Featured Artist</label>
                    <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="{{ $track->feature_artist ?? '' }}" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="artistTitle">Title</label>
                    <input type="text" class="form-control" name="title" id="Release-Title" required value="{{ $track->title ?? '' }}">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="mainGenre">Main Genre</label>
                    <select name="genre_id" id="genre_id" class="form-control" required>
                        <option value="">Select Genre</option>
                        @foreach($genres as $genre)
                        <option value="{{ $genre->id }}" @if($track->genre_id==$genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                        @endforeach
                    </select>

                </div>
            </div>


            <div class="col-md-6" id="tracksubgenredata">
                <div class="form-group single-artist">
                    <label class="form-label" for="subGenre">Sub Genre</label>
                    <select name="subgenre_id" id="subgenre_id" class="form-control">
                        <option value="">Select Sub Genre</option>

                        @php
                        $subgenres = App\Models\SubGenre::where('genre_id',$track->genre_id)->get();
                        @endphp

                        @foreach($subgenres as $subgenre)
                        <option value="{{ $subgenre->id }}" @if($track->subgenre_id == $subgenre->id) selected @endif>{{ $subgenre->title }}</option>
                        @endforeach

                    </select>
                </div>
            </div>


            {{--<div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="disk">Disk</label>
                    <input class="form-control" name="disc" type="text" id="disk" value="{{ $track->disc }}" />
                </div>
            </div>--}}

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="track">Track#</label>
                    <input class="form-control" name="serial_number" type="text" id="serial_number" value="{{ $track->serial_number }}" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="arranger">Arranger</label>
                    <input class="form-control" type="text" id="arranger" value="{{ $track->arranger }}" name="arranger" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="actor">Actor</label>
                    <input class="form-control" type="text" id="actor" value="{{ $track->actor }}" name="actor">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="coductor">Conductor</label>
                    <input class="form-control" type="text" id="conductor" value="{{ $track->conductor }}" name="conductor" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="composer">Composer</label>
                    <input class="form-control" type="text" id="composer" value="{{ $track->composer }}" name="composer" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="mixVersion">Mix Version</label>
                    <input class="form-control" type="text" id="mix_version" name="mix_version" value="{{ $track->mix_version }}" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="chooseRemixer">Choose Remixer</label>
                    <select name="remixer" id="remixer" class="form-control">
                        <option value="">Select Remixer</option>
                        @foreach(getTrackRemixers() as $remixer)
                        <option @if($track->remixer == $remixer) selected @endif value="{{ $remixer }}">
                            {{ $remixer }}
                        </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="orEnter">Or Enter Remixer(s)</label>
                    <input class="form-control" type="text" id="remixer_list" name="remixer_list[]" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="orchestra">Orchestra</label>
                    <input class="form-control" type="text" id="orchestra" value="{{ $track->orchestra }}" name="orchestra" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="publisher">Publisher</label>
                    <input class="form-control" type="text" id="publisher" name="publisher" value="{{ $track->publisher }}" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="contributors">Contributors</label>
                    <input class="form-control" type="text" id="contributors" name="contributors" value="{{ $track->contributors }}" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Price Tires (For iTunes Only)</label>

                    <select name="price_tier" id="price_tier" class="form-control">
                        <option value="">Select Price Tier</option>
                        @foreach(release_prices_tires() as $price_key => $price_val)
                        <option value="{{ $price_key}}" @if($track->price == $price_key) selected @endif>
                            {{ $price_val }}
                        </option>
                        @endforeach

                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Audio File (Must be Wav - 44.1khz)</label>
                    <input class="form-control custom-file-input" type="file" id="my_audio_files" accept=".wav" name="my_audio_files" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Do you have ISRC?</label>
                    <div class="main-form-radio d-flex justify-content-start gap-3">

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="have_isrc" id="yes"  value="1" @if($track->have_isrc == 1) checked @endif />
                            <label class="form-check-label" for="yes">Yes</label>
                        </div>

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="have_isrc" id="no" value="0" @if($track->have_isrc == 0) checked @endif />
                            <label class="form-check-label" for="no">No</label>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-check-main">
                    <div class="form-check single-artist-check">
                        <input class="form-check-input" type="checkbox" id="explicit" name="explicit" value="1" 
                        @if($track->explicit == 1) checked @endif />
                        <label class="form-check-label" for="orEnter">Explicit</label>
                    </div>
                    <div class="form-check single-artist-check">
                        <input class="form-check-input" type="checkbox" id="sold_with_album" name="sold_with_album" value="1" @if($track->sold_with_album == 1) checked @endif />
                        <label class="form-check-label" for="orEnter">Yes, this track can be sold with full album</label>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    <div class="modal-footer">
        <button type="submit" class="btn add-single-btn">Update</button>
    </div>
</form>


