@extends('layouts.app')
@section('content')

@if(empty(Session::get('release_form_show')))
<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Release</h6>
        </div>
    </div>

    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <form class="add-releses-form" method="POST" action="{{ route('release.labels.save') }}" id="frmReleaseStep1212" enctype="multipart/form-data">
        @csrf
        <div class="releases-sec-main">
            <div class="row">
                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Label<i class="fa-solid fa-circle-info"></i></label>
                        <select name="label_id" id="admin_label_id" class="form-control">
                            <option value="">Select Label</option>
                            @foreach($lablesUsers as $user)
                            <option value="{{ $user->id }}" @if($release->label_id == $user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                @php
                if(!empty($release->label_id)){
                $label_id = $release->label_id;
                $sublabels = getSublabelByLabelId($label_id);
                }
                @endphp


                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="releaseSubLabelsOfLabels">
                    <div class="form-group main-form">
                        <label class="form-label required" for="language">Sub Label
                            <i class="fa-solid fa-circle-info">
                            </i></label>
                        <select name="sublabel_id" id="sublabel_id" class="form-control">
                            <option value="">Select Sub Label</option>
                            @if(!empty($sublabels))
                            @foreach($sublabels as $sublabel)
                            <option value="{{ $sublabel->id }}" @if($release->sublabel_id == $sublabel->id) selected @endif>{{ $sublabel->name }}</option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                </div>

                <div class="form-group-button frm_genre_nextform">
                    <button type="submit" class="btn lyricsBtn" id="lyricsSubmit">Next Step</button>
                </div>

            </div>
        </div>
    </form>
</section>

<script>
    $("#admin_label_id").change(function() {
        var label_id = $(this).val();
        // alert(label_id);return false;
        $.ajax({
            url: "{{ route('release.getsublabels.oflables') }}",
            type: "POST",
            data: {
                'label_id': label_id,
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                if (html) {
                    $("#releaseSubLabelsOfLabels").html(html);
                }
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });
</script>
@endif

@php
$selectedLabels = null;
if(Session::get('release_labels')){
$selectedLabelArr = Session::get('release_labels');

if(!empty($selectedLabelArr['lable']))
{
$selectedLabelId = $selectedLabelArr['lable'];
$user = getUserById($selectedLabelId);
$selectedLabels = $user->name ?? '';
}

if(!empty($selectedLabelArr['sublabel'])){
$selectedLabelId = $selectedLabelArr['sublabel'];
$user = getUserById($selectedLabelId);
$selectedLabels = $user->name ?? '';
}
}
@endphp



<section class="right-sidebar" id="sidebarRight" @if(empty(Session::get('release_form_show'))) style="display:none;" @endif>

    @if (count($errors) > 0)
    <div class="alert alert-danger">
        <label>Whoops!</label> There were some problems with your input.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach

        </ul>
    </div>
    @endif

    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit Release</h6>
        </div>
        <div class="mt-4">
            <a href="{{ route('release.labels.delete') }}" style="float: right;color: #35bdaa;">
                <i class="fa fa-arrow-left" aria-hidden="true"></i>
            </a>
            <div class="tab-heading">
                <h6>Release Type</h6>
            </div>

            <ul class="nav nav-tabs rel-type-main" id="myTab" role="tablist">
                <li class="nav-item radio-btn rel-type-box" role="presentation">
                    <input type="radio" name="release_form_type" class="form-check-input" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="true" checked>

                    <label class="form-check-label" for="">Album</label>
                </li>
            </ul>


            @if(!empty($release->artwork))
                <style>
                    .albumartworkpreviewimage{
                        background-image: url("{{ Storage::url($release->artwork) }}")
                    }
                    </style>
            @endif


            @if(!empty($release->apple_art))
                <style>
                    .albumappleartworkpreviewimage{
                        background-image: url("{{ Storage::url($release->apple_art) }}")
                    }
                    </style>
            @endif

            <!-- Tab Content -->
            <div class="tab-content mt-3">
                <!-- for album  -->
                <div class="tab-pane fade s how active show" id="profile">

                    <form class="add-releses-form" method="POST" action="{{ route('release.album.update', $release->id) }}" id="frmReleaseStepAlbum1" enctype="multipart/form-data">
                    @csrf
                        <input type="hidden" class="form-control" name="release_type" value="album">

                        <div class="chose-file-sec">
                            <div class="chose-mainbox albumartworkpreviewimage" id="release_album_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>

                                @if(empty($release->artwork))
                                <div class="chose-file-content" id="album_chose-file-content_artwork">
                                    <h5 class="required">Choose file for Art Work</h5>
                                </div>
                                @endif

                                <input type="file" name="artwork" id="album_artwork_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
                                <p id="album_error-message" style="color:#dc3545"></p>
                            </div>

                            <div class="chose-mainbox albumappleartworkpreviewimage" id="release_album_apple_art_work">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>

                                @if(empty($release->apple_art))
                                <div class="chose-file-content" id="album_apple_chose-file-content_artwork">
                                    <h5>Choose file for Apple (Motion Art)</h5>
                                </div>
                                @endif

                                <input type="file" name="apple_art" id="album_apple_art_file" class="form-control" style="display:none;" accept=".jpg, .jpeg, .png" />
                            </div>


                            <div class="chose-mainbox" data-bs-toggle="modal" data-bs-target="#addAlbumLyrics">
                                <div class="file-icon">
                                    <i class="fa-solid fa-plus"></i>
                                </div>
                                <div class="chose-file-content">
                                    <h5>Add Lyrics</h5>
                                </div>

                            </div>

                            <div class="modal fade add-lyricist-modal" id="addAlbumLyrics" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Add Lyricist</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
                                        </div>

                                        <div class="modal-body">
                                            <div class="Upload-mainbox" id="releaseuploadlyrics">
                                                <div class="file-icon">
                                                    <i class="fa-solid fa-plus"></i>
                                                </div>
                                                <h5>Upload Lyrics</h5>
                                            </div>
                                            <p>Or</p>

                                            <input type="file" name="singleReleaseLyricFile" id="albumReleaseLyricFile" class="form-control" style="display:none;" accept=".txt" />
                                            <div class="form-group">
                                                <label class="form-label" for="uploadLyrics">Paste</label>
                                                <input class="form-control" type="text" id="lyric_urls" name="lyric_urls" value="{{ $release->lyric_urls ?? ''}}" />
                                            </div>
                                            <div class="form-group-button">
                                                <button type="button" class="btn lyricsBtn" id="albumReleaselyricsSubmit">Upload</button>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="releases-sec-main">
                            <!-- <form class="add-releses-form"> -->
                            <div class="row">
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="language">Language<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="lang" id="language" class="form-control" required>
                                            <option value="">Select Language</option>
                                            @foreach(getLangs() as $langCode => $langName)
                                            <option value="{{ $langCode }}" @if($release->lang == $langCode ) selected @endif>{{ ucfirst($langName) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="Release-Title">Release Title<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="title" id="Release-Title" required value="{{ $release->title ?? ''}}">
                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="primary-artist">Choose Primary Artist<i class="fa-solid fa-circle-info"></i></label>

                                        <div class="artist-sec">
                                            <select name="artists" id="artists" class="form-control" required>
                                                <option value="">Select Artist</option>
                                                @foreach($artists as $artist)
                                                <option value="{{ $artist->id }}" 
                                                @if( $release->artists==$artist->id) selected @endif>
                                                {{ ucfirst($artist->name) }}
                                                </option>
                                                @endforeach
                                            </select>
                                            @can(['create-artists'])
                                            <a href="javascript:void(0);" id="addAlbumArtistRelease">
                                                <button type="button" class="btn artist-sec-btn"><i class="fa-solid fa-plus"></i>Add Artist</button>
                                            </a>
                                            @endcan
                                        </div>

                                        <!-- Add artist modals -->

                                    </div>
                                </div>
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="display-artist">Display Artist<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" name="display_artist" id="display-artist" value="{{ $release->display_artist ?? ''}}" />
                                    </div>
                                </div>

                                @php
                                $user = Auth::user();
                                $userRoles = null;
                                if ($user && $user->roles->isNotEmpty()) {
                                $role = $user->roles->first();
                                $userRoles = $role->name;
                                }
                                @endphp

                                @if(!empty($userRoles) && $userRoles!="Super Admin")
                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Label<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="label_id" id="label_id" class="form-control">
                                            <option value="">Select Label</option>
                                            @foreach($lablesUsers as $user)
                                            <option value="{{ $user->id }}" @if($release->label_id==$user->id) selected @endif >{{ ucfirst($user->name) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                @endif


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label" for="label">Do you have UPC?<i class="fa-solid fa-circle-info"></i></label>
                                        <div class="main-form-radio d-flex justify-content-start gap-3">

                                            <div class="radio-btn">
                                                <input type="radio" value="1" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_yes"  
                                                @if($release->is_upc==1) checked @endif />
                                                <label class="form-check-label" for="yes">Yes</label>
                                            </div>

                                            <div class="radio-btn">
                                                <input  type="radio" value="0" class="form-check-input me-1 albumReleaseUPC" name="is_upc" id="is_upc_no" @if($release->is_upc==0) checked @endif >
                                                <label class="form-check-label" for="no">No</label>
                                            </div>

                                        </div>
                                    </div>
                                </div>


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label @if($release->is_upc==1) required @endif" id="upc_label_req_album" for="upc">UPC/EAN<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" class="form-control" placeholder="upc/ean" id="single_upc_number_album" name="upc_number"  value="{{ $release->upc_number ?? '' }}"
                                        @if($release->upc_number) required @else readonly disabled @endif
                                        />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cline">C-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line" class="form-control" placeholder="C-Line" id="cline" value="{{ $release->c_line ?? ''}}" required />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="cLineYear">C-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="c_line_year" class="form-control" placeholder="C-Line Year" id="c_line_year" value="{{ $release->c_line_year ?? ''}}" required />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pline">P-Line<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line" class="form-control" placeholder="P-Line" id="pline" required  value="{{ $release->p_line ?? ''}}" />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="pLineYear">P-Line Year<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="text" name="p_line_year" class="form-control" placeholder="P-Line Year" id="pLineYear" required value="{{ $release->p_line_year ?? ''}}" />
                                    </div>
                                </div>

                                @php 
                                $releaseDate = date('Y-m-d');
                                if(!empty($release->release_date)){
                                    $date = new DateTime($release->release_date);
                                    $releaseDate =  $date->format('Y-m-d');
                                }
                               
                                @endphp


                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="release_date">Release Date<i class="fa-solid fa-circle-info"></i></label>
                                        <input type="date" class="form-control" placeholder="Release Date" id="release_date" name="release_date" required value="{{ $releaseDate ?? ''}}" />
                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="main_genre">Main Genre<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="genre_id" id="albumgenre_id" class="form-control" required>
                                            <option value="">Select Genre</option>
                                            @foreach($genres as $genre)
                                            <option value="{{ $genre->id }}" @if($release->genre_id==$genre->id) selected @endif >{{ ucfirst($genre->title) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                @php 
                                if(!empty($release->genre_id)){
                                    $subgenres = getSubGenreByGenreId($release->genre_id);
                                }
                                @endphp 

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3" id="albumsubgenredata">
                                    <div class="form-group main-form">
                                        <label class="form-label required" for="sub_genre">Sub Genre<i class="fa-solid fa-circle-info"></i></label>
                                        <select name="subgenre_id" id="subgenre_id" class="form-control" required>
                                            <option value="">Select Sub Genre</option>
                                            @if(!empty($subgenres)) 
                                                @foreach($subgenres as $subgenre)
                                                <option value="{{ $subgenre->id }}"  @if($release->subgenre_id==$subgenre->id) selected @endif>{{ $subgenre->title }}</option>
                                                @endforeach
                                            @endif
                                        </select>

                                    </div>
                                </div>

                                <div class=" col-md-6 col-lg-6 col-xl-4 col-xxl-3">


                                <div class="form-group main-form">
                                    <label class="form-label required" for="lyricist">Composer
                                        <i class="fa-solid fa-circle-info"></i></label>

                                    <div class="sub-sec">
                                        <input type="text" class="form-control" placeholder="First Name" id="Composer" name="composer" required value="{{ $release->composer ?? ''}}" />

                                        <input type="text" name="composer_lastname" class="form-control" placeholder="Last Name" id="composer_lastname" value="{{ $release->composer_lastname ?? ''}}" required />
                                    </div>
                                </div>

                            </div>


                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label required" for="lyricist">Lyricist<i class="fa-solid fa-circle-info"></i></label>
                                    <div class="sub-sec">
                                        <input type="text" name="lyricist_firstname" class="form-control" placeholder="First" id="lyricist_firstname" required value="{{ $release->lyricist_firstname ?? ''}}" />

                                        <input type="text" name="lyricist_lastname" class="form-control" placeholder="Last" id="lyricist_lastname"  required value="{{ $release->lyricist_lastname ?? ''}}" />
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="catalogue_no">Catalogue Number<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" name="cat_number" class="form-control" placeholder="Catalogue Number" id="cat_number" value="{{ $release->cat_number ?? ''}}" />

                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="fe_artist">Featured Artist<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="{{ $release->feature_artist ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="fe_artist">Is Instrumental?<i class="fa-solid fa-circle-info"></i></label>

                                    <div class="main-form-radio d-flex justify-content-start gap-3">

                                        <div class="radio-btn">
                                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_yes" value="1" 
                                            @if($release->is_instrumental==1) selected @endif
                                             />
                                            <label class="form-check-label" for="is_yes">Yes</label>
                                        </div>

                                        <div class="radio-btn">
                                            <input type="radio" class="form-check-input me-1" name="is_instrumental" id="is_no" checked value="0" 
                                            @if($release->is_instrumental==0) selected @endif  />
                                            <label class="form-check-label" for="is_no">No</label>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="actor">Actor<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Actor" id="actor" name="actor" value="{{ $release->actor ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="conductor">Conductor<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Conductor" id="conductor" name="conductor" value="{{ $release->conductor ?? ''}}">
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="remixer">Remixer<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Remixer" id="remixer" name="remixer" value="{{ $release->remixer ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="arranger">Arranger<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Arranger" id="arranger" name="arranger" value="{{ $release->arranger ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">


                                    <label class="form-label sub-label" for="start">CRBT (Start Time)</label>
                                    <input class="form-control" type="time" class="form-control" placeholder="08:30" id="crbt_start_time" name="crbt_start_time" value="{{ $release->crbt_start_time ?? ''}}" />


                                </div>
                            </div>




                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="copyright_fe">Copyright<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Copyright" id="copyright_fe" name="copyrights" value="{{ $release->copyrights ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="orchestra">Orchestra<i class="fa-solid fa-circle-info"></i></label>
                                    <input type="text" class="form-control" placeholder="Orchestra" id="orchestra" name="orchestra" value="{{ $release->orchestra ?? ''}}" />
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="parental_warn">Parental Warning Type<i class="fa-solid fa-circle-info"></i></label>

                                    <select name="parental_warning_type" id="parental_warning_type" class="form-control">

                                        <option value="NotExplicit" 
                                        @if($release->parental_warning_type=="NotExplicit" ) selected @endif
                                        >NotExplicit
                                    </option>
                                        <option value="Explicit"  
                                        @if($release->parental_warning_type=="Explicit" ) selected @endif>Explicit</option>
                                        <option value="ExplicitContentEdited"  
                                        @if($release->parental_warning_type=="ExplicitContentEdited" ) selected @endif>ExplicitContentEdited</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6 col-lg-6 col-xl-4 col-xxl-3">
                                <div class="form-group main-form">
                                    <label class="form-label" for="price_tiers">Price Tiers (For iTunes Only)<i class="fa-solid fa-circle-info"></i></label>
                                    <select name="price_tier" id="price_tier" class="form-control">
                                        <option value="">Select Price Tier</option>
                                        @foreach(release_prices_tires() as $price_key => $price_val)
                                        <option value="{{ $price_key}}" @if($release->price_tier==$price_key) selected @endif>
                                            {{ $price_val }}
                                        </option>
                                        @endforeach

                                    </select>


                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form">
                                    <label class="form-label" for="release_desc">Release Descriptions</label>
                                    <textarea style="height: 131px;" name="description" id="description" class="form-control">{{ $release->description }}</textarea>

                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12 col-xl-12">
                                <div class="form-group main-form d-flex gap-2">
                                    <button type="submit" class="btn main-next-btn">Next</button>
                                </div>
                            </div>
                        </div>
                        <!-- </form> -->
                </div>
                </form>



            </div>

        </div>
    </div>
    </div>

</section>



<script type="text/javascript">
    $(document).ready(function() {

        $("#frmReleaseStepAlbum1").validate({
            rules: {
                title: {
                    required: true
                },
                artists: {
                    required: true
                },
                p_line: {
                    required: true
                },
                c_line: {
                    required: true
                },
                p_line_year: {
                    required: true
                },
                c_line_year: {
                    required: true
                },
                release_date: {
                    required: true
                },
                composer: {
                    required: true
                },
                composer_lastname: {
                    required: true
                },

                genre_id: {
                    required: true
                },

                subgenre_id: {
                    required: true
                },

                lyricist_firstname: {
                    required: true
                },
                lyricist_lastname: {
                    required: true
                },



            },
            messages: {
                title: {
                    required: "Title field is required"
                },
                artists: {
                    required: "Artists field is required"
                },
                p_line: {
                    required: "P Line field is required"
                },

                c_line: {
                    required: "C Line field is required"
                },

                p_line_year: {
                    required: "P Line Year field is required"
                },

                c_line_year: {
                    required: "C Line Year field is required"
                },

                release_date: {
                    required: "Release Date field is required"
                },
                composer: {
                    required: "Composer First Name field is required"
                },
                composer_lastname: {
                    required: "Composer Last Name field is required"
                },
                genre_id: {
                    required: "Genre field is required"
                },
                subgenre_id: {
                    required: "Sub Genre field is required"
                },
                lyricist_firstname: {
                    required: "Lyricist First Name field is required"
                },
                lyricist_lastname: {
                    required: "Lyricist Last Name field is required"
                },
            },
            submitHandler: function(form) {
                $('#frm_submit_loading').show();
                form.submit();
            },
            invalidHandler: function(event, validator) {
                $('#frm_submit_loading').hide();;
            }
        });

        let isAlbumAppleClickTriggered = false;
        $('#release_album_apple_art_work').click(function() {
            if (!isAlbumAppleClickTriggered) {
                isAlbumAppleClickTriggered = true;
                $('#album_apple_art_file').trigger('click');
                isAlbumAppleClickTriggered = false;
            }
        });


        let isAlbumArtWorkClickTriggered = false;
        $('#release_album_art_work').click(function() {
            if (!isAlbumArtWorkClickTriggered) {
                isAlbumArtWorkClickTriggered = true;
                $('#album_artwork_file').trigger('click');
                isAlbumArtWorkClickTriggered = false;
            }
        });


        $('#album_artwork_file').on('change', function(e) {
            var file = e.target.files[0];
            if (file && file.type.startsWith('image/')) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('.albumartworkpreviewimage').css({
                        'background-image': 'url("' + event.target.result + '")'
                    });
                    $('#album_chose-file-content_artwork').hide();
                    $('#album_error-message').hide();
                }
                reader.readAsDataURL(file);
            } else {
                alert('Please select a valid image file');
                return false;
            }
        });

        $('#album_apple_art_file').on('change', function(e) {
            var file = e.target.files[0];
            if (file && file.type.startsWith('image/')) {
                var reader = new FileReader();
                reader.onload = function(event) {
                    $('.albumappleartworkpreviewimage').css({
                        'background-image': 'url("' + event.target.result + '")'
                    });
                    $('#album_apple_chose-file-content_artwork').hide();
                }
                reader.readAsDataURL(file);
            } else {
                alert('Please select a valid image file');
                return false;
            }
        });



        $('#frmReleaseStepAlbum1').submit(function(e) {
            // Get the file input element
            var fileInput = $('#album_artwork_file')[0];
            var file = fileInput.files[0];

            // Clear previous error messages
            $('#album_error-message').hide();
            // Check if a file was selected
            if (!file) {
                $('#album_error-message').text('Art Work field is required').show();
                e.preventDefault(); // Prevent form submission
                return false;
            }

        });


        $(document).on('click', '#albumReleaselyricsSubmit', function() {
            var file = $('#albumReleaseLyricFile')[0].files[0]; // Get the file
            var formData = new FormData(); // Create FormData object
            formData.append('file', file); // Append the file to FormData
            formData.append('_token', "{{ csrf_token() }}"); // Append CSRF token to FormData

            $.ajax({
                url: "{{ route('upload.release.single.lyrics') }}",
                type: 'POST',
                data: formData, // Send FormData
                contentType: false, // Don't set content type because FormData sets it automatically
                processData: false, // Don't process data because it's a file upload
                xhr: function() {
                    var xhr = new XMLHttpRequest();
                    xhr.upload.addEventListener('progress', function(e) {
                        if (e.lengthComputable) {
                            $("#addAlbumLyrics").hide();
                            $('#addAlbumLyrics').modal('hide');
                            var percent = (e.loaded / e.total) * 100;
                            $('#albumprogressBar').css('width', percent + '%');
                            $('#albumprogressBar').text(Math.round(percent) + '%');
                        }
                    }, false);

                    return xhr;
                },
                success: function(response) {
                    // alert('File uploaded successfully!');
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while uploading the file');
                }
            });
        });

        $("#addAlbumArtistRelease").click(function() {
            $.ajax({
                url: "{{ route('release.artist.create') }}",
                type: "POST",
                data: {
                    'flag': 'release',
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(html) {
                    window.location.href = "{{ route('artists.create') }}";
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("#albumgenre_id").change(function() {
            var genre_id = $(this).val();
            $.ajax({
                url: "{{ route('release.subgenre') }}",
                type: "POST",
                data: {
                    'genre_id': genre_id,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(html) {
                    html = html.replace("<strong>", "<label>");
                    html = html.replace("</strong>", "</label>");
                    $("#albumsubgenredata").html(html);
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                    return false;
                }
            });
        });


        $("input:radio.albumReleaseUPC").click(function() {
            if ($('input:radio.albumReleaseUPC:checked').val() == "1") {
                $('#single_upc_number_album').prop('disabled', false);
                $('#single_upc_number_album').removeAttr('readonly');
                $('#single_upc_number_album').attr('required', true);
                $('#upc_label_req_album').addClass('required');
            }

            if ($('input:radio.albumReleaseUPC:checked').val() == "0") {
                $('#single_upc_number_album').val('');
                $('#single_upc_number_album').prop('disabled', true);
                $('#single_upc_number_album').attr('readonly', true);
                $('#single_upc_number_album').removeAttr('required', true);
                $('#upc_label_req_album').removeClass('required');
            }

        });







    });


    let islyricsClickTriggered = false;
    $(document).on('click', '#releaseuploadlyrics', function() {
        if (!islyricsClickTriggered) {
            islyricsClickTriggered = true;
            $('#albumReleaseLyricFile').trigger('click');
            islyricsClickTriggered = false;
        }
    });



    $("input:radio[name=is_instrumental]").click(function() {
        if ($('input:radio[name=is_instrumental]:checked').val() == "0") {
            $('#lyricistData').show();
        }
        if ($('input:radio[name=is_instrumental]:checked').val() == "1") {
            $('#lyricistData').hide();
        }
    });

    $("input:radio[name=is_upc]").click(function() {
        if ($('input:radio[name=is_upc]:checked').val() == "1") {
            $('#single_upc_number').prop('disabled', false);
            $('#single_upc_number').removeAttr('readonly');
            $('#single_upc_number').attr('required', true);
            $('#upc_label_req').addClass('required');
        }
        if ($('input:radio[name=is_upc]:checked').val() == "0") {
            $('#single_upc_number').val('');
            $('#single_upc_number').prop('disabled', true);
            $('#single_upc_number').attr('readonly', true);
            $('#single_upc_number').removeAttr('required', true);
            $('#upc_label_req').removeClass('required');
        }
    });


    $("#genre_id").change(function() {
        var genre_id = $(this).val();
        $.ajax({
            url: "{{ route('release.subgenre') }}",
            type: "POST",
            data: {
                'genre_id': genre_id,
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                html = html.replace("<strong>", "<label>");
                html = html.replace("</strong>", "</label>");
                $("#subgenredata").html(html);
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });


    $("#addArtistRelease").click(function() {
        $.ajax({
            url: "{{ route('release.artist.create') }}",
            type: "POST",
            data: {
                'flag': 'release',
                "_token": "{{ csrf_token() }}"
            },
            cache: false,
            success: function(html) {
                window.location.href = "{{ route('artists.create') }}";
            },
            error: function(textStatus, errorThrown) {
                alert('Something went wrong!');
                return false;
            }
        });
    });
</script>

@php
Session::forget('release_form_show');
@endphp

@endsection