@extends('layouts.app')

@section('content')

<section class="right-sidebar" id="sidebarRight">
        <div class="view-release-sec">
            <div class="view-release">
                <div class="view-release-heading">
                    <h6>View Genre</h6>
                </div>

                @can(['create-genre'])
                <div class="view-all-release-search">
                    <a href="{{ route('genre.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
                </div>
                @endcan


            </div>

            <div class="viewReleases-main-sec">
                <table class="table table-bordered">
                    <thead>
                      <tr>
                      <th>No</th>
                        <th>Genre Name</th>
                        <th>Genre Description</th>
                        <th>Genre Status</th>
                        <th width="280px">Action</th>
                       </tr>
                    </thead>
                    <tbody>
                     
                    @foreach ($data as $key => $genre)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $genre->title }}</td>
                        <td>{{ $genre->description }}</td>
                        <td>

                        @can(['edit-genre'])
                        <input  type="checkbox" id="genre_{{ $genre->id }}" class="form-check-input genreStatus" name="genreStatus"  @if($genre->status==1) checked @endif />
                        @endcan


                        @if(!empty($genre->status))
                            <label id="genreStatus_{{ $genre->id }}" class="badge bg-success">Active</label>
                            @else
                            <label id="genreStatus_{{ $genre->id }}" class="badge bg-danger">Disabled</label>
                        @endif
                        </td>
                        <td>

                           @can(['edit-genre'])
                            <a class="btn btn-primary btn-sm" href="{{ route('genre.edit',$genre->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            @endcan

                            @can(['delete-genre'])
                            <!-- Delete Button -->
                            <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal" data-genre-id="{{ $genre->id }}">
                                <i class="fa-solid fa-trash"></i> Delete
                            </button>
                            @endcan


                        </td>
                    </tr>
                @endforeach
                     
                    </tbody>
                  </table>
                  {!! $data->links('pagination::bootstrap-5') !!}


                  <!-- Delete Confirmation Modal -->
                    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    Are you sure you want to delete this genre?
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                    <form id="deleteForm" method="POST" action="{{ route('genre.destroy', '') }}">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>



            </div>
        </div>
    </section>
   



    <script>
    $(document).ready(function(){
        // Handle the checkbox change (genre status toggle)
        $(".genreStatus").change(function(){
            var genreStr = $(this).attr('id');
            var genreArr = genreStr.split("_");
            var genreId = genreArr[1];

            $.ajax({
                url: "{{route('genre.status.update')}}",
                type: "POST",
                data: {genreId : genreId, "_token": "{{ csrf_token() }}" },
                cache: false,
                success: function(requestResponse){
                    var genreStatusId = "genreStatus_" + genreId;
                    if(requestResponse == "disabledGenre"){
                        $(this).prop('checked', false);
                        $("#" + genreStatusId).removeClass("bg-success").addClass("bg-danger").text("Disabled");
                    } else if(requestResponse == "activeGenre"){
                        $(this).prop('checked', true);
                        $("#" + genreStatusId).removeClass("bg-danger").addClass("bg-success").text("Active");
                    }
                },
                error: function(response){
                    alert('Something went wrong!');
                    console.log(response);
                }
            });
        });

        // Handle delete button click to set the correct form action
        $('#deleteModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget);
            var genreId = button.data('genre-id');
            var actionUrl = "{{ route('genre.destroy', ':id') }}".replace(':id', genreId);
            $('#deleteForm').attr('action', actionUrl);
        });
    });
</script>


@endsection

