@extends('layouts.app')

@section('content')


<section class="right-sidebar" id="sidebarRight">
    <div class="releases-section">
        <div class="release-sec-heading">
            <h6>Edit DSP</h6>
        </div>

        <div class="releases-sec-main">

            @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form class="add-releses-form" method="POST" action="{{ route('dsp.update', $dsp->id) }}" id="frmAddDSP">
                @csrf
                @method('PUT')

                <div class="row">

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <label class="form-label required" for="dsp">DSP Name
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Enter the name of the DSP."></i>
                            </label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $dsp->name }}" />
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form mt-5">
                            <label class="form-label required" for="status">DSP Status
                                <i class="fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-placement="top" title="Select whether the DSP is active or disabled."></i>
                            </label>
                            <select name="status" id="status" class="form-control">
                                <option @if($dsp->status==1) selected @endif value="1">Active</option>
                                <option @if($dsp->status==0) selected @endif value="0">Disabled</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12 col-lg-12 col-xl-12">
                        <div class="form-group main-form">
                            <button type="submit" class="btn main-next-btn">Update</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.fa-circle-info'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        // Validate form input
        $("#frmAddDSP").validate({
            rules: {
                name: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                name: {
                    required: "DSP Name field is required"
                },
                status: {
                    required: "DSP Status field is required"
                },
            }
        });
    });
</script>




{{--
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Edit DSP</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('dsp.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
        </div>
    </div>
</div>

@if (count($errors) > 0)
<div class="alert alert-danger">
    <strong>Whoops!</strong> There were some problems with your input.<br><br>
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form method="POST" action="{{ route('dsp.update', $dsp->id) }}">
    @csrf
    @method('PUT')

    <div class="row">

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>DSP Name:</strong>
                <input type="text" name="name" placeholder="DSP Name" class="form-control" value="{{ $dsp->name }}">
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>DSP Status:</strong>
                <select name="status" id="status" class="form-control">
                    <option @if($dsp->status==1) selected @endif value="1">Active</option>
                    <option @if($dsp->status==0) selected @endif value="0">Disabled</option>
                </select>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk"></i> Submit</button>
        </div>
    </div>
</form>
--}}

@endsection