@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Content Management</h2>
        </div>

        <div class="pull-right">
            <a class="btn btn-success mb-2" href="{{ route('contents.create') }}"><i class="fa fa-plus"></i> Create New Content</a>
        </div>

    </div>
</div>

@session('success')
    <div class="alert alert-success" role="alert"> 
        {{ $value }}
    </div>
@endsession

<table class="table table-bordered">
   <tr>
       <th>No</th>
       <th>Title</th>
       <th>Descriptions</th>
       <th>Images</th>
       <th width="280px">Action</th>
   </tr>
   @foreach ($data as $key => $content)
    <tr>
        <td>{{ ++$i }}</td>
        <td>{{ $content->title }}</td>
        <td>{{ $content->description }}</td>
        <td>
            <div>
                @php 
                if(!empty($content->images)):
                    $images = json_decode($content->images);
                    foreach($images as $image):
                        @endphp 
                        <a href="{{ asset('contents/'.$image)}}" target="_blank">
                            <img src="{{ asset('contents/'.$image)}}" alt="{{ $image }}" style="width: 50px;" />
                    </a>
                        @php 
                    endforeach;

                endif;
                @endphp 
            </div>

        </td>
        <td>
            <a class="btn btn-info btn-sm" href="{{ route('contents.show',$content->id) }}"><i class="fa-solid fa-list"></i> Show</a>
             <a class="btn btn-primary btn-sm" href="{{ route('contents.edit',$content->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
              <form method="POST" action="{{ route('contents.destroy', $content->id) }}" style="display:inline">
                  @csrf
                  @method('DELETE')
                  <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
              </form>
        </td>
    </tr>
 @endforeach
</table>

{!! $data->links('pagination::bootstrap-5') !!}

@endsection
