@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Edit Content</h2>
        </div>
        <div class="pull-right">
            <a class="btn btn-primary btn-sm mb-2" href="{{ route('contents.index') }}"><i class="fa fa-arrow-left"></i> Back</a>
        </div>
    </div>
</div>

@if (count($errors) > 0)
    <div class="alert alert-danger">
      <strong>Whoops!</strong> There were some problems with your input.<br><br>
      <ul>
         @foreach ($errors->all() as $error)
           <li>{{ $error }}</li>
         @endforeach
      </ul>
    </div>
@endif

<form method="POST" action="{{ route('contents.update', $content->id) }}" enctype="multipart/form-data">
    @csrf
    @method('PUT')

    <div class="row">

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Title:</strong>
                <input type="text" name="title" placeholder="Title" class="form-control" value="{{ $content->title }}" required />
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Description:</strong>
                <textarea style="height: 227px;" name="description" id="description" class="form-control" placeholder="Description" required>{{ $content->description }}</textarea>
            </div>
        </div>


        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Images:</strong>
                <input type="file" name="images[]" multiple class="form-control" accept="image/*" />
            </div>
        </div>

        <br /><br /><br />
        <h6>Select for delete images</h6>
        <div>
            <ul class="list list-unstyled">
             @php 
                if(!empty($content->images)):
                    $images = json_decode($content->images);
                    foreach($images as $image):
                        @endphp 
                        <li class="p-2">
                        <input type="checkbox" name="delete_images[]" value="{{ $image }}" />
                        <img src="{{ asset('contents/'.$image)}}" alt="{{ $image }}" style="width: 50px;" />  
                        </li>
                        @php 
                    endforeach;
                endif;
                @endphp 
            </ul>
            </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <button type="submit" class="btn btn-primary btn-sm mt-2 mb-3"><i class="fa-solid fa-floppy-disk">

            </i> Submit</button>
        </div>
    </div>
</form>

@endsection
