document.addEventListener('DOMContentLoaded', function() {

const ctx = document.getElementById('streamsChart').getContext('2d');

        const data = {
            labels: ['21 Jan', '22 Jan', '23 Jan', '24 Jan', '25 Jan', '26 Jan', '27 Jan'],
            datasets: [
                {
                    label: 'Dataset 1',
                    data: [100000, 150000, 75000, 50000, 125000, 80000, 140000],
                    borderColor: '#20b2aa',
                    backgroundColor: 'transparent',
                    pointBorderColor: '#20b2aa',
                    pointBackgroundColor: '#20b2aa',
                    pointRadius: 5,
                    pointStyle: 'rect',
                    borderWidth: 2,
                    tension: 0.4,
                },
                {
                    label: 'Dataset 2',
                    data: [20000, 50000, 120000, 100000, 75000, 200000, 250000],
                    borderColor: 'orange',
                    backgroundColor: 'transparent',
                    pointBorderColor: 'orange',
                    pointBackgroundColor: 'orange',
                    pointRadius: 5,
                    pointStyle: 'rect',
                    borderWidth: 2,
                    tension: 0.4,
                }
            ]
        };

        const config = {
            type: 'line',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    x: { 
                        grid: { 
                            display: true, 
                            lineWidth: 0.5, 
                            color: '#eee' 
                        } 
                    },
                    y: { 
                        beginAtZero: true,
                        grid: { 
                            display: true, 
                            lineWidth: 0.5, 
                            color: '#eee' 
                        },
                        ticks: {
                            stepSize: 50000 
                        }
                    }
                }
            }
        };

        new Chart(ctx, config);



// ########### horizontal bar ##########

const hBar = document.getElementById('myChart').getContext('2d');
new Chart(hBar, {
    type: 'bar',
    data: {
        labels: ['', '', ''], // Empty labels for bars
        datasets: [{
            data: [10, 7, 5], // Bar lengths
            backgroundColor: ['#A477fb', '#656ff7', '#35bdaa'],
            borderRadius: 5,
            borderSkipped: false, // Ensures borderRadius applies to all corners
            barThickness: 12, // Reduce bar thickness
            categoryPercentage: 0.4, // Reduced space between bars
            barPercentage: 5.0 // Maximize individual bar width
        }]
    },
    options: {
        indexAxis: 'y', // Horizontal bars
        responsive: true,
        plugins: {
            legend: { display: false } // Hide legend
        },
        scales: {
            x: { display: false, grid: { display: false } }, // Hide x-axis
            y: { display: false, grid: { display: false } }  // Hide y-axis
        }
    },
 
});






// pie chart 

var pieChart = document.getElementById('myPieChart').getContext('2d');
var myPieChart = new Chart(pieChart, {
  type: 'pie', // Specifies a pie chart
  data: {
    labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple'], // Labels for each section
    datasets: [{
      label: 'Pie Chart Example',
      data: [60, 50, 40, 30, 80], // Values for each section
      backgroundColor: ['#ae77f8', '#656ff7', '#ff8e6f', '#ffb748', '#35bdaa'], // 5 colors for each section
      hoverOffset: 4
    }]
  },
  options: {
    responsive: true, // Make it responsive to window resizing
    plugins: {
      legend: {
        position: 'none', // Position of the legend
      },
      tooltip: {
        enabled: true, // Enable tooltips
      }
    }
  }
});


const vBar = document.getElementById('customBarChart').getContext('2d');

        new Chart(vBar, {
            type: 'bar',
            data: {
                labels: ['', '', '', '', ''], // Hides x-axis labels
                datasets: [{
                    data: [250000, 180000, 40000, 25000, 75000], // Only values
                    backgroundColor: ['#ae77fb', '#656ff7', '#ff8e6f', '#ffb748', '#35bdaa'],
                    borderWidth: 0,
                    barPercentage: 0.6, // Reduces bar thickness
                    categoryPercentage: 0.5, // Adjusts spacing
                    borderRadius: 10 // Adds rounded corners
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false } // Hides dataset label
                },
                scales: {
                    x: {
                        grid: { display: false }, // Removes x-axis grid
                        ticks: { display: false } // Hides x-axis labels
                    },
                    y: {
                        grid: { display: false }, // Removes y-axis grid
                        ticks: { display: true } // Keeps y-axis labels
                    }
                }
            }
        });




// doughnutChart 

var doughNut = document.getElementById('doughnutChart').getContext('2d');

var doughnutChart = new Chart(doughNut, {
  type: 'doughnut',
  data: {
    labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple'],
    datasets: [{
      label: 'Dataset Example',
      data: [60, 50, 40, 30, 80], // Values for each section
      backgroundColor: [
        '#ae77fb', // Red
        '#656ff7', // Green
        '#ff8e6f', // Yellow
        '#ffb748', // Blue
        '#35bdaa'  // Purple
      ],
      hoverOffset: 8 // Expands segment on hover
    }]
  },
  options: {
    responsive: true,
    plugins: {
      legend: {
        position: 'none' // Moves legend to the top
      },
      tooltip: {
        enabled: true // Enables tooltips
      }
    }
  }
});

});