<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Temporarily disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::statement('ALTER TABLE model_has_permissions DROP FOREIGN KEY model_has_permissions_permission_id_foreign;');



        // Delete existing permissions if necessary
        Permission::truncate();

        $permissions = [
            'create-role',
            'edit-role',
            'delete-role',

            'create-user',
            'edit-user',
            'delete-user',


            'view-genre',
            'create-genre',
            'edit-genre',
            'delete-genre',

            'view-subgenre',
            'create-subgenre',
            'edit-subgenre',
            'delete-subgenre',

            'view-artists',
            'create-artists',
            'edit-artists',
            'delete-artists',

            'view-country',
            'create-country',
            'edit-country',
            'delete-country',

            'view-dsp',
            'create-dsp',
            'edit-dsp',
            'delete-dsp',

            'view-userdsp',
            'create-userdsp',
            'edit-userdsp',
            'delete-userdsp',

            'view-sublabel',
            'create-sublabel',
            'edit-sublabel',
            'delete-sublabel'


         ];
 
          // Looping and Inserting Array's Permissions into Permission Table
         foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
          }

    }
}
