<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'single_audio_file')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('single_audio_file');
            });
        }
        Schema::table('releases', function (Blueprint $table) {
            $table->string('single_audio_file')->nullable()->after('apple_art');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('single_audio_file');
        });
    }
};
