<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('releases', 'lyric_urls')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('lyric_urls');
            });
        }
        Schema::table('releases', function (Blueprint $table) {
            $table->text('lyric_urls')->nullable()->after('lyrics_file');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('lyric_urls');
        });
    }
};
