<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('artists', 'isrc')) {
            Schema::table('artists', function (Blueprint $table) {
                $table->dropColumn('isrc');
            });
        }

        Schema::table('artists', function (Blueprint $table) {
            $table->string('isrc')->nullable()->after('website');
        });
       
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('artists', function (Blueprint $table) {
            $table->dropColumn('isrc');
        });
    }
};
