<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {


        if (Schema::hasColumn('releases', 'published_date')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('published_date');
            });
        }


        Schema::table('releases', function (Blueprint $table) {
            $table->dateTime('published_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('published_date');
        });
    }
};
