<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('releases', 'upc_number')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('upc_number');
            });
        }

        Schema::table('releases', function (Blueprint $table) {
            $table->string('upc_number')->after('is_upc');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('upc_number');
        });
    }
};
