<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tracks', function (Blueprint $table) {
            $table->id();
            $table->integer('release_id')->nullable();
            $table->string('disc')->nullable();
            $table->string('artists')->nullable();
            $table->string('display_artist')->nullable();
            $table->string('feature_artist')->nullable();
            $table->string('title')->nullable();
            $table->string('mix_version')->nullable();
            $table->string('remixer')->nullable();
            $table->string('orchestra')->nullable();
            $table->string('arranger')->nullable();
            $table->string('actor')->nullable();
            $table->string('conductor')->nullable();
            $table->string('composer')->nullable();
            $table->integer('genre_id')->nullable();
            $table->integer('subgenre_id')->nullable();
            $table->string('publisher')->nullable();
            $table->string('contributors')->nullable();
            $table->boolean('have_isrc')->default(false);
            $table->string('isrc_number')->nullable();
            $table->boolean('sold_with_album')->default(false);
            $table->boolean('explicit')->default(false);
            $table->time("start_time")->nullable();
            $table->time("end_time")->nullable();
            $table->integer('price')->nullable();
            $table->longText('audio_files')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tracks');
    }
};
