<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('permissions', 'label')) {
            Schema::table('permissions', function (Blueprint $table) {
                $table->dropColumn('label');
            });
        }


        Schema::table('permissions', function (Blueprint $table) { 
            $table->string('label')->nullable()->after('guard_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->dropColumn('label');
        });
    }
};
