<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;

class Track extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *	
     * @var array
     */
    public const DISABLED = 0;
    public const ACTIVE = 1;

    /**
     * The attributes that are mass assignable.
     *	
     * @var array
     */
    protected $fillable = [
        'release_id', 'serial_number','disc','artists', 'display_artist','feature_artist','title','mix_version','remixer','orchestra','arranger','actor','conductor','composer','genre_id','subgenre_id','publisher','contributors','have_isrc','isrc_number','sold_with_album','explicit','start_time','end_time','price','audio_files'
    ];
}
