<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Genre extends Model
{
    public const ACTIVE = 1;
    public const DISABLED = 0;
    /**
     * The attributes that are mass assignable.
     *	
     * @var array
     */
    protected $fillable = [
        'title', 'description', 'status'
    ];

    public static function getGenres(){
        return self::where('status',self::ACTIVE)->get();
    }

    public static function getGenreById($id){
        return self::where('id',$id)->first();
    }
}
