<?php

namespace App\Http\Controllers;

use App\Models\UPCS;
use App\Http\Requests\StoreUPCSRequest;
use App\Http\Requests\UpdateUPCSRequest;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class UPCSController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:create-upcs|edit-upcs|delete-upcs', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-upcs', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-upcs', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-upcs', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $totalRecords = UPCS::count();
        $newRecords =  UPCS::where('status', UPCS::NEW)->count();
        $oldRecords =  UPCS::where('status', UPCS::USED)->count();

        $data = UPCS::latest()->paginate(itemsPerPage());
        return view('upcs.index', compact('data', 'totalRecords', 'newRecords', 'oldRecords'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        $roles = Role::pluck('name', 'name')->all();
        return view('upcs.create', compact('roles'));
    }



    public function manualUpload(Request $request)
    {
        user_logs();
        $this->validate($request, [
            'upload_file' => 'required|file|mimes:csv,txt'
        ]);

        // Get the uploaded file
        $csvFile = $request->file('upload_file');

        // Open the CSV file
        $csvData = file_get_contents($csvFile->getRealPath());

        // Split the CSV data into rows
        $rows = explode("\n", $csvData);

        // Skip the header row
        array_shift($rows);

        // Insert the data into the database
        foreach ($rows as $row) {
            $data = str_getcsv($row);
            $model = new UPCS();
            $model->upc =  isset($data[0]) ? $data[0] : '';
            $model->ean =  isset($data[1]) ? $data[1] : '';
            $model->status =  0;
            $model->save();
        }
        return redirect()->route('upcs.index')
            ->with('success', 'UPC uploaded successfully');
    }



    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreUPCSRequest $request)
    {
        user_logs();
        $input = $request->all();
        UPCS::create($input);
        return redirect()->route('upcs.index')->with([
            'message' => 'UPC created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(UPCS $uPCS)
    {
        user_logs();
        $upc = UPCS::find($uPCS->id);
        return view('upcs.show', compact('upc'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(UPCS $uPCS)
    {
        user_logs();
        $upc = UPCS::find($uPCS->id);
        return view('upcs.edit', compact('upc'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateUPCSRequest $request, UPCS $uPCS)
    {
        user_logs();
        $input = $request->all();
        $upc = UPCS::find($uPCS->id);
        $upc->update($input);

        return redirect()->route('upcs.index')->with([
            'message' => 'UPC updated successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(UPCS $uPCS)
    {
        user_logs();
        UPCS::find($uPCS->id)->delete();
            return redirect()->route('upcs.index')->with([
                'message' => 'UPC deleted successfully',
                'alert-type' => 'success'
            ]);
    }
}
