<?php

namespace App\Http\Controllers;

use App\Models\Genre;
use App\Http\Requests\StoreGenreRequest;
use App\Http\Requests\UpdateGenreRequest;
use App\Models\Log;
use Illuminate\Http\Request;

class GenreController extends Controller
{

    public function __construct(){
        $this->middleware('auth');
        $this->middleware('permission:view-genre|create-genre|edit-genre|delete-genre', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-genre', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-genre', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-genre', ['only' => ['destroy']]);
    }


    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $data = Genre::latest()->paginate(itemsPerPage());
        return view('genres.index', compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        return view('genres.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGenreRequest $request)
    {
        user_logs();
        $input = $request->all();
        Genre::create($input);
        return redirect()->route('genre.index')->with([
            'message' => 'Genre created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Genre $genre)
    {
        user_logs();
        $genre = Genre::find($genre->id);
        return view('genres.show', compact('genre'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Genre $genre)
    {
        user_logs();
        $genre = Genre::find($genre->id);
        return view('genres.edit', compact('genre'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGenreRequest $request, Genre $genre)
    {
        user_logs();
        $input = $request->all();
        $genre = Genre::find($genre->id);
        $genre->update($input);
        return redirect()->route('genre.index')->with([
            'message' => 'Genre updated successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Genre $genre)
    {
        user_logs();
        Genre::find($genre->id)->delete();

        return redirect()->route('genre.index')->with([
            'message' => 'Genre deleted successfully',
            'alert-type' => 'success'
        ]);
    }

    public function statusUpdate(Request $request)
    {

        $response = null;
        $input = $request->all();
        $genreId = $input['genreId'];
        $genre = Genre::find($genreId);

        if ($genre->status) {
            $genre->status = Genre::DISABLED;
            $response = 'disabledGenre';
        } else {
            $genre->status = Genre::ACTIVE;
            $response = 'activeGenre';
        }
        $genre->save();
        return $response;
    }
}
