<?php

namespace App\Http\Controllers;

use App\Models\Dsp;
use App\Http\Requests\StoreDspRequest;
use App\Http\Requests\UpdateDspRequest;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Models\User;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

class DspController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:view-dsp|create-dsp|edit-dsp|delete-dsp', ['only' => ['index', 'show']]);
        $this->middleware('permission:create-dsp', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-dsp', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete-dsp', ['only' => ['destroy']]);
    }


    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        user_logs();
        $data = Dsp::latest()->paginate(50);
        return view('dsps.index', compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        user_logs();
        return view('dsps.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDspRequest $request)
    {
        user_logs();
        $input = $request->all();
        Dsp::create($input);

        return redirect()->route('dsp.index')->with([
            'message' => 'DSP created successfully',
            'alert-type' => 'success'
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(Dsp $dsp)
    {
        user_logs();
        $dsp = Dsp::find($dsp->id);
        return view('dsps.show', compact('dsp'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Dsp $dsp)
    {
        user_logs();
        $dsp = Dsp::find($dsp->id);
        return view('dsps.edit', compact('dsp'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDspRequest $request, Dsp $dsp)
    {
        user_logs();
        $input = $request->all();
        $dsp = Dsp::find($dsp->id);
        $dsp->update($input);

        return redirect()->route('dsp.index')->with([
            'message' => 'DSP updated successfully',
            'alert-type' => 'success'
        ]);
    }

    public function statusUpdate(Request $request)
    {
        $response = null;
        $input = $request->all();
        $id = $input['dspId'];
        $dsp = Dsp::find($id);

        if ($dsp->status) {
            $dsp->status = Dsp::DISABLED;
            $response = 'disabledDSP';
        } else {
            $dsp->status = Dsp::ACTIVE;
            $response = 'activeDSP';
        }
        $dsp->save();
        return $response;
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Dsp $dsp)
    {
        user_logs();
        Dsp::find($dsp->id)->delete();

        return redirect()->route('dsp.index')->with([
            'message' => 'DSP deleted successfully',
            'alert-type' => 'success'
        ]);
    }
}
